# -*- coding: utf-8 -*-
from mpfs.common.util.experiments.logic import experiment_manager
from mpfs.config import settings
from mpfs.core.billing import ProductCard
from mpfs.core.email.logic import send_email_async_by_uid
from mpfs.core.promo_codes.logic.discount_manager import DiscountManager
from mpfs.core.promo_codes.logic.errors import AttemptToActivateArchivedDiscount, AttemptToActivateDiscountRepeatedly
from mpfs.engine.process import get_default_log
from mpfs.engine.queue2.celery import BaseTask, app
from mpfs.core.services.ps_billing_service import ps_billing
from mpfs.core.services.passport_service import passport

default_log = get_default_log()

PROMO_COME_BACK_USER_DISCOUNT_DISCOUNT_TEMPLATE_ID = settings.promo['come_back_user_discount']['discount_template_id']
PROMO_COME_BACK_USER_DISCOUNT_EMAIL_CAMPAIGN_NAME = settings.promo['come_back_user_discount']['email_campaign_name']
FEATURE_TOGGLES_REDIRECT_COMEBACK_DISCOUNT_TO_PS_BILLING = settings.feature_toggles['redirect_comeback_discount_to_ps_billing']
PROMO_COME_BACK_USER_DISCOUNT_PS_BILLING_PROMO_KEY = settings.promo['come_back_user_discount']['ps_biling_promo_key']


@app.task(base=BaseTask)
def handle_provide_discount_to_come_back_user(uid, context=None, **kwargs):
    if not experiment_manager.is_feature_active('come_back_users'):
        return
    if FEATURE_TOGGLES_REDIRECT_COMEBACK_DISCOUNT_TO_PS_BILLING:
        country = passport.userinfo(uid).get('country')
        if country is None:
            default_log.info("Discount can't be provided for uid=%s country is unknown" % uid)
            return
        if country == 'ru':
            ps_billing.activate_promo(PROMO_COME_BACK_USER_DISCOUNT_PS_BILLING_PROMO_KEY, uid, activate_if_used=True,
                                      send_email=True)
            default_log.info("Discount request for uid=%s redirected to ps-billing" % uid)
            return
    try:
        DiscountManager.add_discount_to_user(uid, PROMO_COME_BACK_USER_DISCOUNT_DISCOUNT_TEMPLATE_ID)
    except AttemptToActivateArchivedDiscount:
        DiscountManager.restore(uid, PROMO_COME_BACK_USER_DISCOUNT_DISCOUNT_TEMPLATE_ID)
    except AttemptToActivateDiscountRepeatedly:
        return
    default_log.info('come back user discount provided for uid=%s' % uid)
    send_email_async_by_uid(
        uid,
        PROMO_COME_BACK_USER_DISCOUNT_EMAIL_CAMPAIGN_NAME,
        template_args={'products': ProductCard.get_current_products_for(uid)}
    )
