# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.engine.queue2.celery import BaseTask, app
from mpfs.config import settings
from mpfs.core import factory
from mpfs.core.address import ResourceId
from mpfs.core.services.data_api_service import DataApiDocsService
from mpfs.core.user.constants import (
    DISK_AREA_PATH,
    ATTACH_AREA_PATH,
)

log = mpfs.engine.process.get_default_log()
DOCS_DATABASES = settings.docs['databases']

@app.task(base=BaseTask)
def handle_delete_objects_in_docs(uid, context=None, **kwargs):
    log.info('Start delete docs from datasync for uid=%s' % uid)
    for database in DOCS_DATABASES:
        deleted_docs = 0
        data_api_docs_service = DataApiDocsService(database)
        items = data_api_docs_service.get_all_user_docs(uid)
        items_with_resource_ids = filter(lambda doc: doc.get('resource_id') is not None, items)
        if not items_with_resource_ids:
            continue
        resource_ids = [ResourceId.parse(i['resource_id']) for i in items_with_resource_ids]
        existed_resources = factory.get_resources_by_resource_ids(uid, resource_ids, enable_service_ids=[DISK_AREA_PATH, ATTACH_AREA_PATH])
        existed_resource_ids = [resource.resource_id.serialize() for resource in existed_resources if resource is not None]
        for resource in items_with_resource_ids:
            if resource['resource_id'] not in existed_resource_ids:
                try:
                    data_api_docs_service.delete_doc_item(uid, resource['id'])
                    deleted_docs += 1
                except data_api_docs_service.api_error:
                    pass
        log.info('Deleted %s docs from datasync %s for uid=%s' % (deleted_docs, database, uid))



