# -*- coding: utf-8 -*-
from mpfs.core.global_gallery.logic.controller import GlobalGalleryController
from mpfs.engine.queue2.celery import BaseTask, app


@app.task(base=BaseTask)
def handle_add_source_ids(uid, hid, source_ids, is_live_photo=False, context=None, **kwargs):
    if not source_ids:
        return
    GlobalGalleryController.add_source_ids_to_file(uid, hid, source_ids, is_live_photo)


@app.task(base=BaseTask)
def handle_add_deletion_log_record_if_needed_by_file_data(uid, file_id, hid, is_live_photo=False, context=None, **kwargs):
    GlobalGalleryController.add_deletion_log_record(uid, file_id, hid, is_live_photo=is_live_photo)


@app.task(base=BaseTask)
def handle_set_live_photo_flag_to_source_ids_and_add_one(uid, source_ids, hid, context=None, **kwargs):
    GlobalGalleryController.set_live_photo_flag_to_source_ids_and_add_one(uid, source_ids, hid)
