# -*- coding: utf-8 -*-
import traceback
from demjson import JSONDecodeError

import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.queue import mpfs_queue
from mpfs.common import errors
from mpfs.engine.queue2.celery import BaseTask, app


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


@app.task(base=BaseTask)
def handle_failing_operation(uid, oid, error, context=None, **kwargs):
    if len(kwargs):
        error_log.warning('unexpected arguments in operation %s (%s)' % ('handle_failing_operation', str(kwargs)))

    from mpfs.core.operations import manager as operation_manager
    try:
        operation = operation_manager.get_operation(uid, oid)
        operation.set_failed_queue(error)
    except JSONDecodeError, e:
        # если не возможно разобрать JSON в data операции, то аварийно фэйлим её.
        error_log.error(traceback.format_exc())
        operation_manager.emergency_set_failed(uid, oid)
    except errors.OperationNotFound:
        error_log.error('operation %s:%s not found' % (uid, oid))
    except Exception:
        error_log.error(traceback.format_exc())
        mpfs_queue.put(
            {
                'uid': uid,
                'oid': oid,
                'error': error
            },
            'operation_failing',
            delay=settings.operations['faildelay']
        )
        raise
