# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.common.errors import TryAgain
from mpfs.common.static.tags import STATUS, ERROR
from mpfs.common.util import to_json
from mpfs.config import settings
from mpfs.core.pushnotifier.controller import PushController
from mpfs.core.pushnotifier.sync.controller import BrowserPushController
from mpfs.engine.http.client import open_url
from mpfs.engine.queue2.celery import BaseTask, app

log = mpfs.engine.process.get_default_log()

QUEUE2_PUT_TASKS_IN_NEW_QUEUE = settings.queue2['put_tasks_in_new_queue']


@app.task(base=BaseTask)
def handle_push_notification(context=None, task_data=None, **kwargs):
    if task_data:  # В task_data данные передаются через монгу, если в kwargs данных слишком много, а само оно сбрасывается в None
        kwargs = task_data.data
    PushController().send(kwargs)


@app.task(base=BaseTask)
def handle_push_notify_subscribe(uid=None, callback=None, options=None, service_callback=None, context=None, **kwargs):
    try:
        PushController().subscribe(uid, callback, options)
        if service_callback:
            _call_callback(service_callback, {STATUS: 'DONE'})
    except Exception as e:
        if not QUEUE2_PUT_TASKS_IN_NEW_QUEUE:
            raise
        if service_callback:
            _call_callback(service_callback, {ERROR: {'message': type(e)}, STATUS: 'FAILED'})


@app.task(base=BaseTask)
def handle_push_xiva_browser(context=None, **kwargs):
    BrowserPushController().send(kwargs)


def _call_callback(callback_url, data):
    try:
        open_url(callback_url, method='POST', pure_data=to_json(data),
                 rais=True, headers={'Content-Type': 'application/json'})
    except Exception:
        log.error('Service callback failed: %s' % callback_url)
