# -*- coding: utf-8 -*-


import mpfs.engine.process

from mpfs.core.filesystem.symlinks import Symlink
from mpfs.core.social.share import ShareProcessor
from mpfs.core.user.base import User
from mpfs.core.user.constants import *
from mpfs.engine.queue2.celery import BaseTask, app

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


@app.task(base=BaseTask)
def handle_post_modify_user_settings(uid, key, type, action, project, value, namespace,
                                     context=None, **kwargs):

    # Пока не обрабатываем то, что не связано:
    # - с Диском, - другими неймспейсами и настройками
    if not (project == 'disk' and namespace == DEFAULT_NAMESPACE and type == 'states'):
        return

    User(uid, project).states.immediately_post_process(key, value, namespace, action)


@app.task(base=BaseTask)
def handle_post_process_user_init(uid, referral, context=None, **kwargs):
    if referral is None:
        return

    import mpfs.core.user.invites
    mpfs.core.user.invites.process_friend_activation(uid, referral)


@app.task(base=BaseTask)
def handle_process_device_install(uid, type, id, info, context=None, **kwargs):
    auto_set_states = {
        'desktop': 'desktop_installed',
        'mobile': 'mobile_installed',
    }
    if type in auto_set_states:
        user = User(uid)
        user.states.set(auto_set_states[type], 1, pended=False)
        # Если у пользователя уже есть девайс, то нужно проверить есть ли соответствующие сиды в паспорте
        # и выставить их, если сидов нет. Постпроцессинг пользовательских настроек срабатывает не всегда,
        # в комментах к тикету описан соответствующий сценарий.
        # https://jira.yandex-team.ru/browse/CHEMODAN-16125
        # Проверку и выставление нужных сидов отлично умеют делать 2 метода:
        if type == 'desktop':
            user.passport_subscribe_desktop()
        elif type == 'mobile':
            user.passport_subscribe_mobile()

    import mpfs.core.user.devices
    mpfs.core.user.devices.process_device_installation(uid, type, id, info)

    import mpfs.core.user.invites
    mpfs.core.user.invites.process_device_installation(uid, type, id)


@app.task(base=BaseTask)
def handle_passport_user_deleted_event(uid, context=None, **kwargs):
    """«Подмести мусор» после того как пользователь удалился из паспорта.

    Выполняет следующий список действий:
      * Удаляет все публичные ссылки пользователя.
      * Пользователь покидает все группы, где был участником.
      * Кикаем всех из групп, где пользователь был владельцем.
    """
    # удаляем все публичные ссылки
    symlinks = Symlink.list_all(uid=uid)
    for symlink in symlinks:
        if symlink is not None:
            symlink.delete()

    # покидаем все группы, где пользователь был участником
    sp = ShareProcessor()
    links = sp.list_owned_links(uid=uid)
    groups_ids = [link.gid for link in links]
    for group_id in groups_ids:
        sp.leave_group(uid=uid, gid=group_id)

    # кикаем всех пользователей из групп, где переданный пользователь является владельцем
    groups = sp.list_owned_groups(owner=uid)
    for group in groups:
        for joined_uid in group.iteruids():
            sp.kick_user(owner=uid, uid=joined_uid, gid=group.gid)
