# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from mpfs.common.errors.lenta import LentaTooLargeBlockSizeError, LentaEmptyBlockError
from mpfs.config import settings
from mpfs.core.lenta.logic.lenta_block_list import _load_resource
from mpfs.core.albums.interface import _albums_create
from mpfs.metastorage.postgres.schema import AlbumType

MAX_BLOCK_SIZE_TO_CREATE_ALBUM_FOR = settings.lenta['max_block_size_to_create_album_for']


def lenta_create_album_from_block(req):
    # FIXME: Функция находится внутри logic, но принимает запрос. Да, это плохо. Надеюсь в будущем поправим. :)
    # FIXME: Но сейчас нет возможности легко сделать интерфейс для функции lenta_block_list, поскольку она изменяет
    # FIXME: ресурс через resource.set_request(req) и прокидывает параметры через 100500 слоёв.
    title = req.title
    layout = req.layout
    flags = req.flags.split(',')

    # защита от загрузки 100500 ресурсов (будет загружено максимум MAX_BLOCK_SIZE_TO_CREATE_ALBUM_FOR + 1)
    # если наберем MAX_BLOCK_SIZE_TO_CREATE_ALBUM_FOR + 1 => блок слишком большой,
    # иначе размер блока <= MAX_BLOCK_SIZE_TO_CREATE_ALBUM_FOR
    amount = req.args.data['bounds']['amount']
    amount = min((amount, MAX_BLOCK_SIZE_TO_CREATE_ALBUM_FOR + 1))
    req.args.data['bounds']['amount'] = amount
    req.args_data.data['bounds']['amount'] = amount

    folder_resource = _load_resource(req)

    folder_content = folder_resource.children_items['files']
    if not folder_content:
        raise LentaEmptyBlockError()
    if len(folder_content) > MAX_BLOCK_SIZE_TO_CREATE_ALBUM_FOR:
        raise LentaTooLargeBlockSizeError()

    items = []
    for resource in folder_content:
        items.append(
            {'type': 'resource', 'path': resource.path}
        )
    raw_album = {
        'title': title,
        'cover': 0,
        'layout': layout,
        'flags': flags,
        'items': items,
        'album_type': AlbumType.PERSONAL.value,
    }
    album = _albums_create(req, raw_album)
    return album
