# -*- coding: utf-8 -*-
from mpfs.common.util import from_json
from mpfs.core.filesystem.helpers.lock import LockHelper
from mpfs.core.locks.validators import validate
from mpfs.core.metastorage.control import fs_locks
from mpfs.engine.process import get_error_log


error_log = get_error_log()


def locks_list(req):
    """
    Возвращает список lock'ов пользователя.

    Query string аргументы:
      * uid [обязательный]
    """
    return fs_locks.find_all(req.uid)


def locks_delete(req):
    """
    Удаляет lock по пути.

    Query string аргументы:
      * uid [обязательный]
      * path - путь до ресурса. [обязательный]
    """
    lock_helper = LockHelper()
    raw_address = '%s:%s' % (req.uid, req.path)

    lock_helper.unlock(raw_address)


def locks_set(req):
    """
    Выставляем lock по пути.

    Query string аргументы:
      * uid [обязательный]
      * path - путь до ресурса. [обязательный]

    Тело запроса:
    {
        "oid": "<oid операции>",
        "op_type": "<тип операции"
    }
    """
    lock_data = from_json(req.http_req.data)
    validate(lock_data)

    raw_address = '%s:%s' % (req.uid, req.path)

    lock_helper = LockHelper()
    lock_helper.lock(raw_address, data=lock_data)
    return lock_helper.get_lock(raw_address)
