# -*- coding: utf-8 -*-
FIELDS = {'op_type', 'office_lock_id', 'oid'}
FIELDS_TYPE = str
FIELDS_LENGTH_LIMIT = 256


def validate(lock_data):
    if lock_data is None:
        return

    if not FIELDS.issuperset(lock_data.keys()):
        raise ValueError('Wrong fields for lock_data: expected %s.' % FIELDS)

    for name, value in lock_data.items():
        if isinstance(value, FIELDS_TYPE):
            raise ValueError('Field "%s" has wrong type: expected %s, was %s.' % (name,
                                                                                  FIELDS_TYPE,
                                                                                  type(value)))
        if len(value) > FIELDS_LENGTH_LIMIT:
            raise ValueError('Field "%s" is too long: limit=%s.' % (name, FIELDS_LENGTH_LIMIT))
