# -*- coding: utf-8 -*-
"""

MPFS
CORE

Модуль подключения всех нужных data source

"""
import mpfs.engine.process

from mpfs.metastorage.mongo.collections.base import UserIndexCollection
from mpfs.metastorage.mongo.collections.reindex import (
    QuickMoveReindexTasksCollection,
    QuickMoveReindexSettingsCollection
)

from mpfs.metastorage.mongo.collections.system import (
    DiskInfoCollection,
    RecountCollection,
    RegerateVideoInfoFails
)

from mpfs.metastorage.mongo.collections.filesystem import (
    UserDataCollection,
    HiddenDataCollection,
    TrashCollection,
    MiscDataCollection,
    AttachDataCollection,
    NarodDataCollection,
    NotesDataCollection,
    DeletedPreviewMidsCollection,
    LinkDataCollection,
    Groups,
    GroupInvites,
    GroupLinks,
    FilesystemLocksCollection,
    PhotounlimDataCollection,
    AdditionalDataCollection,
    ClientDataCollection,
)

from mpfs.metastorage.mongo.collections.clean import (
    DeletedStidsCollection,
    DeletedStidsRetryRemoveCollection,
    StorageCleanCheckStidsCollection
)

from mpfs.metastorage.mongo.collections.operations import (
    OperationsCollection
)

from mpfs.metastorage.mongo.collections.support import (
    SupportMpfsCollection,
    SupportModerationQueueMpfsCollection,
    SupportBlockedHidsCollection,
    SupportBlockHistoryCollection,
    SupportProhibitedCleaningUsersCollection
)

from mpfs.metastorage.mongo.collections.changelog import (
    ChangelogCollection
)

from mpfs.metastorage.mongo.collections.tags import (
    TagCollection
)

from mpfs.metastorage.mongo.collections.invites import (
    InviteMpfsSent,
    InviteMpfsReferralsCollection,
    InviteMpfsCodesCollection,
    InviteMpfsContactsCollection
)

from mpfs.metastorage.mongo.collections.billing import (
    BillingClientAttributes,
    BillingServices,
    BillingServicesHistory,
    BillingServiceAttributes,
    BillingServiceAttributesHistory,
    BillingOrders,
    BillingOrdersHistory,
    BillingSubscriptions,
    BillingLocks
)

from mpfs.metastorage.mongo.collections.tasks import AsyncTasksDataCollection
from mpfs.metastorage.mongo.collections.office import OfficeAllowedPDDDomainsCollection
from mpfs.metastorage.mongo.collections.versioning import (
    VersionDataCollection,
    VersionLinksCollection,
)

# disk
user_index = UserIndexCollection()
disk = UserDataCollection()
hidden_data = HiddenDataCollection()
trash = TrashCollection()
misc = MiscDataCollection()
attach = AttachDataCollection()
notes = NotesDataCollection()
lnarod = NarodDataCollection()
disk_info = DiskInfoCollection()
link_data = LinkDataCollection()
operations = OperationsCollection()
tag_data = TagCollection()
changelog = ChangelogCollection()
version_data = VersionDataCollection()
version_links = VersionLinksCollection()
photounlim = PhotounlimDataCollection()
additional_data = AdditionalDataCollection()
client_data = ClientDataCollection()

# clean
deleted_stids = DeletedStidsCollection()
deleted_stids_retry_remove = DeletedStidsRetryRemoveCollection()
storage_clean_check_stids = StorageCleanCheckStidsCollection()

# system
deleted_preview_mids = DeletedPreviewMidsCollection()
fs_locks = FilesystemLocksCollection()
recount = RecountCollection()
regerate_video_info_fails = RegerateVideoInfoFails()


# invites
invite_mpfs_codes = InviteMpfsCodesCollection()
invite_mpfs_contacts = InviteMpfsContactsCollection()
invite_mpfs_referrals = InviteMpfsReferralsCollection()
invite_mpfs_sent = InviteMpfsSent()

# shared folders
groups = Groups()
group_links = GroupLinks()
group_invites = GroupInvites()

# billing
billing_client_attributes = BillingClientAttributes()
billing_services = BillingServices()
billing_services_history = BillingServicesHistory()
billing_service_attributes = BillingServiceAttributes()
billing_service_attributes_history = BillingServiceAttributesHistory()
billing_orders = BillingOrders()
billing_orders_history = BillingOrdersHistory()
billing_subscriptions = BillingSubscriptions()
billing_locks = BillingLocks()

# browser sync
sync_subscription = None
queue_sync = None
browser = None
browser_states = None

# support
support = SupportMpfsCollection()
support_moderation_queue = SupportModerationQueueMpfsCollection()
support_blocked_hids = SupportBlockedHidsCollection()
support_block_history = SupportBlockHistoryCollection()
support_prohibited_cleaning_users = SupportProhibitedCleaningUsersCollection()

# async queue data
async_tasks_data = AsyncTasksDataCollection()

# office allowed PDD domains
office_allowed_pdd_domains = OfficeAllowedPDDDomainsCollection()

# коллекции для запуска переиндексации для быстрого мува
quick_move_reindex_tasks = QuickMoveReindexTasksCollection()
quick_move_reindex_settings = QuickMoveReindexSettingsCollection()
