# -*- coding: utf-8 -*-
import datetime

from mpfs.engine.process import setup_admin_script, get_default_log
setup_admin_script()
from mpfs.core.services.juggler import JStatus, FrozenOperationsCommonJEvent, FrozenOperationsImportantJEvent
from mpfs.core.mrstat.stat_utils import quit_if_mrstat_disabled
from mpfs.core.operations.logic import frozen
from mpfs.core.operations.logic.frozen import OperationSignificance
from mpfs.core.mrstat.stat_utils import StatPublisher
from mpfs.config import settings

default_log = get_default_log()

FROZEN_OPERATIONS_CRIT_LIMIT = settings.frozen_operations_monitoring['crit_limit']

REPORT_CONFIG_YAML = """
---
dimensions:
- fielddate: date
measures:
- important_ops: number
- common_ops: number
"""


def send_to_juggler(status, event, message):
    juggler_event = event(status, description=message)
    default_log.info('SEND EVENT: %r', juggler_event)
    juggler_event.send()


def publish_to_stat(important_ops, common_ops):
    now_dt = datetime.datetime.now()
    StatPublisher.create_and_upload(
        'Disk/DiskInternal/FrozenOperations',
        'Зависшие операции. Важные и Обычные.',
        REPORT_CONFIG_YAML,
        [{'fielddate': now_dt.strftime('%Y-%m-%d %H:%M:00'),
          'important_ops': important_ops,
          'common_ops': common_ops}],
        scale='i')


def main():
    important_count = frozen.get_frozen_important_operations_count()
    common_count = frozen.get_frozen_common_operations_count()

    for op_count, jevent_type, name in ((important_count, FrozenOperationsImportantJEvent, OperationSignificance.important),
                                        (common_count, FrozenOperationsCommonJEvent, OperationSignificance.common)):
        status = JStatus.CRIT if op_count > FROZEN_OPERATIONS_CRIT_LIMIT[name] else JStatus.OK
        message = "Found %s frozen operations. %s" % (op_count, jevent_type.__name__)
        default_log.info(message)
        try:
            send_to_juggler(status, jevent_type, message)
        except Exception as e:
            default_log.exception("%r", e)

    try:
        publish_to_stat(important_count, common_count)
    except Exception as e:
        default_log.exception("%r", e)


if __name__ == '__main__':
    quit_if_mrstat_disabled()
    default_log.info("start.")
    main()
