#!/usr/bin/env python
# -*- coding: utf-8 -*-
from mpfs.core.mrstat.report import Job, parse_args


class ReportJob(Job):
    operations = (
        {
            'type': 'map',
            'cmd': './main.py combined_raw_map',
            'src': ('//statbox/mpfs-access-log/{date}',),
            'dst': ('{yt_home_prefix}/tmp/{report_name}/map',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'reduce',
            'cmd': './main.py reduce_hits',
            'src': ('{yt_home_prefix}/tmp/{report_name}/map',),
            'dst': ('{yt_home_prefix}/results/{report_name}/{scale}/{first_date}_rpm',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'publish',
            'yt_path': '{yt_home_prefix}/results/{report_name}/{scale}/{first_date}_rpm',
            'report_path': 'Disk/DiskInternal/HandleRPM',
            'report_title': 'RPM по ручкам, статусам и хостам',
            'config_path': '{mrstat_dir}/{report_name}/publish.yaml',
        },

        {
            'type': 'map',
            'cmd': './main.py combined_raw_map_request_time',
            'src': ('//statbox/mpfs-access-log/{date}',),
            'dst': ('{yt_home_prefix}/tmp/{report_name}/map_request_time',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'reduce',
            'cmd': './main.py reduce_sum',
            'src': ('{yt_home_prefix}/tmp/{report_name}/map_request_time',),
            'dst': ('{yt_home_prefix}/tmp/{report_name}/red_request_time',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'reduce',
            'cmd': './main.py reduce_hits_request_time',
            'src': ('{yt_home_prefix}/tmp/{report_name}/red_request_time',),
            'dst': ('{yt_home_prefix}/results/{report_name}/{scale}/{first_date}_request_time',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
            'memlimit': 2500,
        },
        {
            'type': 'publish',
            'yt_path': '{yt_home_prefix}/results/{report_name}/{scale}/{first_date}_request_time',
            'report_path': 'Disk/DiskInternal/HandleRequestTime',
            'report_title': 'Request time по ручкам, статусам и хостам',
            'config_path': '{mrstat_dir}/{report_name}/publish.yaml',
        },
    )


if __name__ == '__main__':
    (dates, scale, publish_only) = parse_args()
    ReportJob(scale=scale, dates=dates).run(publish_only=publish_only)
