#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Отчет о пересечении удаленных и запрашиваемых stid

https://st.yandex-team.ru/CHEMODAN-25961
https://stat.yandex-team.ru/Disk/DiskInternal/MulcaCleanIntersection

Как дополнить словарь deleted_stids_ignore_list:
0. Устанавливаем переменные окружения для YT (см disk-secrets)
> export YT_TOKEN=<TOKEN> YT_PROXY=<url>
1. Скачиваем текущий словарь.
> yt download //home/mpfs-stat/storage/deleted_stids_ignore_list > deleted_stids_ignore_list
2. Исправляем словарь.
> vim deleted_stids_ignore_list
3. Заливаем исправленный словарь.
> cat deleted_stids_ignore_list | yt upload //home/mpfs-stat/storage/deleted_stids_ignore_list
"""
from mpfs.core.mrstat.report import Job, parse_args


class ReportJob(Job):
    operations = (
        {
            'type': 'map',
            'cmd': './main.py combined_raw_map',
            'src': ('//statbox/disk-mulca-clean-log/{date}',),
            'dst': ('{yt_home_prefix}/tmp/{report_name}/map',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'reduce',
            'cmd': './main.py reduce_stids',
            'src': ('{yt_home_prefix}/tmp/{report_name}/map',),
            'dst': ('{yt_home_prefix}/tmp/{report_name}/red',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'reduce',
            'cmd': './main.py reduce_final',
            'src': ('{yt_home_prefix}/tmp/{report_name}/red',),
            'dst': ('{yt_home_prefix}/results/{report_name}/{scale}/{first_date}',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'publish',
            'yt_path': '{yt_home_prefix}/results/{report_name}/{scale}/{first_date}',
            'report_path': 'Disk/DiskInternal/MulcaCleanMeasurers',
            'report_title': 'Чистка мульки. Дополнительные метрики.',
            'config_path': '{mrstat_dir}/{report_name}/publish.yaml',
        },
    )


if __name__ == '__main__':
    (dates, scale, publish_only) = parse_args()
    ReportJob(scale=scale, dates=dates).run(publish_only=publish_only)
