#!/usr/bin/env python
# -*- coding: utf-8 -*-
from statbox import mrlib
from statbox import mrtools
from collections import defaultdict


@mrlib.combiner(mrtools.reduce_aggregator(group_by_subkeys=True, do_eval=False))
def combined_map_count_progress(records):
    round_period = mrtools.make_round_period()
    for r in records:
        period = round_period(r.value)
        yield mrlib.Record(period, '', 1)


def reduce_progress_date(date, raw_records):
    real_remove = 0
    for r in raw_records:
        r = int(r.value)
        real_remove += r
    yield mrlib.DummyRecord('', date, real_remove)


def reduce_progress_final(_, raw_records):
    result = defaultdict(lambda: {
        'dry': 0,
        'real': 0,
    })
    for rec in raw_records:
        r = int(rec.value)
        result[rec.subkey]['real'] += r

    total_dry, total_real = 0, 0
    for date in sorted(result.keys()):
        dry, real = result[date]['dry'], result[date]['real']
        total_dry += dry
        total_real += real
        yield mrlib.SimpleTSKVRecord(
            fielddate=date,
            dry=dry,
            total_dry=total_dry,
            real=real,
            total_real=total_real,
        )


if __name__ == '__main__':
    mrtools.run()
