#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Служебный отчет, который поддерживает таблицу удаленных stid-ов в актуальном состоянии

http://yt.yandex.net/plato/#page=navigation&path=//home/mpfs-stat/storage/deleted_stids_v2
"""
from mpfs.core.mrstat.report import Job, parse_args


class ReportJob(Job):
    operations = (
        {
            'type': 'map',
            'cmd': './main.py combined_raw_map_cleaner',
            'src': ('//statbox/disk-mulca-clean-log/{date}',),
            'dst': ('{yt_home_prefix}/tmp/{report_name}/map_cleaner',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
        {
            'type': 'reduce',
            'cmd': './main.py reduce_stids',
            'src': ('{yt_home_prefix}/tmp/{report_name}/map_cleaner',
                    '{yt_home_prefix}/storage/deleted_stids_v2'),
            'dst': ('{yt_home_prefix}/storage/deleted_stids_v2',),
            'files': ('{mrstat_dir}/{report_name}/main.py',),
        },
    )


if __name__ == '__main__':
    (dates, scale, publish_only) = parse_args()
    ReportJob(scale=scale, dates=dates).run(publish_only=publish_only)
