#!/usr/bin/env python
# -*- coding: utf-8 -*-
import statbox.qb
import statbox.qb.filters2 as sf
import statbox.qb.extractors2 as se
from statbox import mrlib
from statbox import mrtools


def combined_raw_map_cleaner(lines):
    """
    Предобрабатываем логи чистильщика мульки
    """
    qb = statbox.qb.QB(
        log='default',
        fields=[
            'datetime',
            se.log_field('stid'),
            se.log_field('can_clean'),
            se.log_field('dry_run'),
        ],
        filters=[
            sf.equals('can_clean', 'True'),
            sf.equals('dry_run', 'False'),
        ]
    )
    for r in qb.map_lines(lines):
        yield mrlib.DummyRecord(r['stid'], '', r['datetime'])


def reduce_stids(stid, raw_records):
    """
    Получение накопительной ифнормации по stid-ам
    """
    least_dt = None
    for r in raw_records:
        if least_dt is None or r.value < least_dt:
            least_dt = r.value
    yield mrlib.DummyRecord(r.key, '', least_dt)


if __name__ == '__main__':
    mrtools.run()
