# -*- coding: utf-8 -*-

import mpfs.engine.process
from mpfs.core.bus import Bus
from mpfs.core import factory
from mpfs.core.address import Address
from mpfs.core.metastorage.decorators import user_is_writeable, user_exists_and_not_blocked

SHARE_UID = mpfs.engine.process.share_user()
SRC_PREFIX = '/share/notes'
DST_PREFIX = '/notes'


@user_exists_and_not_blocked
@user_is_writeable
def notes_init(req):
    src_address = Address.Make(SHARE_UID, "%s/%s" % (SRC_PREFIX, req.src.strip('/')))
    dst_address = Address.Make(req.uid, "%s/%s" % (DST_PREFIX, req.dst.strip('/')))

    fs = Bus()
    fs.copy_resource(req.uid, src_address.id, dst_address.id, force=False, lock_source=False)

    dst_folder = factory.get_resource(req.uid, dst_address)
    for raw_child in dst_folder.list()['list']:
        raw_address = Address.Make(req.uid, raw_child['id']).id
        changes = {
            'note_revision_created': req.note_revision_created,
            'note_attachment_mtime': req.note_attachment_mtime
        }
        fs.setprop(req.uid, raw_address, changes, notify_search=False)

    return {'ok': True}
