# -*- coding: utf-8 -*-

from mpfs.dao.base import BaseDAOItem, BaseDAO
from mpfs.dao.fields import StringField
from mpfs.metastorage.postgres.schema import office_allowed_pdd_domains


class OfficeAllowedPddDomainsDAOItem(BaseDAOItem):
    mongo_collection_name = 'office_allowed_pdd_domains'
    postgres_table_obj = office_allowed_pdd_domains
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = StringField(mongo_path='_id', pg_path=office_allowed_pdd_domains.c.id)


class OfficeAllowedPddDomainsDAO(BaseDAO):
    dao_item_cls = OfficeAllowedPddDomainsDAOItem
