# -*- coding: utf-8 -*-
from mpfs.common.errors.common import MPFSError
from mpfs.common.static import codes
from mpfs.common.static import messages


class OfficeError(MPFSError):
    default_response_code = messages.default_response


class OfficeUnauthorizedError(OfficeError):
    code = codes.OFFICE_UNAUTHORIZED


class OfficeOnlyOfficeKeyMismatch(OfficeError):
    code = codes.OFFICE_ONLY_OFFICE_KEY_MISMATCH


class OfficeUnsupportedActionError(OfficeError):
    code = codes.OFFICE_UNSUPPORTED_ACTION


class OfficeUnsupportedExtensionError(OfficeError):
    code = codes.OFFICE_UNSUPPORTED_EXTENSION


class OfficeBadResourceIdError(OfficeError):
    code = codes.OFFICE_BAD_RESOURCE_ID


class OfficeFileTooLargeError(OfficeError):
    code = codes.OFFICE_FILE_TOO_LARGE


class OfficeNoHandlerFoundError(OfficeError):
    code = codes.OFFICE_NO_HANDLER_FOUND


class OfficeServiceNotSupportedError(OfficeError):
    code = codes.OFFICE_SERVICE_NOT_SUPPORTED_ERROR


class OfficeEmptyFileNotCreatedError(OfficeError):
    code = codes.OFFICE_EMPTY_FILE_NOT_CREATED


class OfficeIsNotAllowedError(OfficeError):
    code = codes.OFFICE_IS_NOT_ALLOWED


class OfficeEditorNotSupportedForSharedEditError(OfficeError):
    code = codes.OFFICE_EDITOR_NOT_SUPPORTED_FOR_SHARED_EDIT


class OfficeRegionNotSupportedForSharedEditError(OfficeError):
    code = codes.OFFICE_REGION_NOT_SUPPORTED_FOR_SHARED_EDIT


class OfficeEditorLockedForSharedEditError(OfficeError):
    code = codes.OFFICE_EDITOR_LOCKED_FOR_SHARED_EDIT


class OfficeEditorOnPlatformForbidden(OfficeError):
    code = codes.OFFICE_EDITOR_ON_PLATFORM_FORBIDDEN


class OfficeFileIsReadOnlyError(OfficeError):
    code = codes.OFFICE_FILE_IS_READ_ONLY


class OfficeStorageNotSupported(OfficeError):
    code = codes.OFFICE_STORAGE_NOT_SUPPORTED


class OfficeNoFreeSpaceKladunError(OfficeError):
    code = codes.OFFICE_NO_FREE_SPACE_KLADUN_ERROR


class OfficeSizeConstraintFailedKladunError(OfficeError):
    code = codes.OFFICE_SIZE_CONSTRAINT_FAILED_KLADUN_ERROR


class OfficePathNotSpecified(OfficeError):
    code = codes.OFFICE_PATH_NOT_SPECIFIED


class OfficeServiceIdNotSpecified(OfficeError):
    code = codes.OFFICE_SERVICE_ID_NOT_SPECIFIED


class OfficeServiceFileIdNotSpecified(OfficeError):
    code = codes.OFFICE_SERVICE_FILE_ID_NOT_SPECIFIED


class OfficeInvalidParameters(OfficeError):
    code = codes.OFFICE_INVALID_PARAMETERS


class OfficeMailAttachmentNotFound(OfficeError):
    code = codes.OFFICE_MAIL_ATTACHMENT_NOT_FOUND


class OfficeInvalidAccessStateParameter(OfficeError):
    code = codes.OFFICE_INVALID_ACCESS_STATE_PARAMETER


class OfficeOnlyOfficeUserLimitReached(OfficeError):
    code = codes.OFFICE_ONLY_OFFICE_USER_LIMIT_REACHED


class OfficeOnlyOfficeFilesLimitReached(OfficeError):
    code = codes.OFFICE_ONLY_OFFICE_FILES_LIMIT_REACHED


class OfficeOnlyOfficePublicFilesLimitReached(OfficeError):
    code = codes.OFFICE_ONLY_OFFICE_PUBLIC_FILES_LIMIT_REACHED


class OfficeOnlyOfficeOutdatedData(OfficeError):
    code = codes.OFFICE_ONLY_OFFICE_OUTDATED_DATA


class OfficeInvalidSelectionStrategyParameter(OfficeError):
    code = codes.OFFICE_INVALID_SELECTION_STRATEGY_PARAMETER


class HancomError(OfficeError):
    pass


class HancomEditNotFinished(HancomError):
    pass


class HancomBadLockError(HancomError):
    pass


class HancomLockNotFound(HancomError):
    pass


class HancomOutdatedModification(HancomError):
    pass
