# -*- coding: utf-8 -*-

from mpfs.core.event_dispatcher.events import subscribe
from mpfs.core.pushnotifier.queue import PushQueue

from .events import OfficeFileConvertedEvent


@subscribe(OfficeFileConvertedEvent)
def push_file_converted_notification(event):
    data = event.data
    key = data['key']
    uid = data['uid']
    connection_id = data['connection_id']

    push_queue = PushQueue()
    push_queue.put({
        'connection_id': connection_id,
        'uid': uid,
        'xiva_data': {
            'root': {
                'tag': 'office',
                'parameters': {
                    'key': key,
                    'type': 'convert',
                }
            }
        },
    })
