# -*- coding: utf-8 -*-
class SettingsVerstkaEditorConst(object):
    u"""Флажки в User.settings.verstka для редактирования"""
    MIGRATED_TO_ONLY_OFFICE_EDITOR_ON_OPEN_CLIENT = 'migratedToOnlyOfficeEditorOnOpenClient'
    u"""Смигрировали юзера на ОО при захочет в front-client"""
    TRIED_TO_MIGRATE_TO_ONLY_OFFICE_EDITOR_ON_OPEN_DOCS = 'triedToMigrateToOnlyOfficeEditorOnOpenDOCS'
    u"""Пытались перевести на OO из DOCSов (сценарий захода в DOCS)"""
    TRIED_TO_MIGRATE_TO_ONLY_OFFICE_EDITOR_ON_EDIT_FILE_FROM_DOCS = 'triedToMigrateToOnlyOfficeEditorOnEditFileFromDOCS'
    u"""Пытались перевести на OO из DOCSов (сценарий открытия файла из DOCS)"""


# не стратегия, но передается в параметр стратегии, если юзер не хочет переходить на OO
SKIP_FORCE_OO = 'skip_force_oo'


class OfficeSourceConst(object):
    DOCS = 'docs'
    MOBILE = 'mobile'


class EditorConst(object):
    ONLY_OFFICE = 'only_office'
    MICROSOFT_ONLINE = 'microsoft_online'


class OfficeSelectionStrategyConst(object):
    FORCE_OO = 'force_oo'
    DEFAULT = 'default'


class OfficeAccessStateConst(object):
    ALL = 'all'
    DISABLED = 'disabled'

    @classmethod
    def values(cls):
        return [cls.ALL, cls.DISABLED]

    @classmethod
    def get_default_value(cls):
        return cls.DISABLED


class OfficeClientIDConst(object):
    DISK = 'disk'
    SHARING_URL = 'd'
    PUBLIC = 'public'


class OfficeServiceIDConst(object):
    SHARING_URL = 'sharing_url'
    DISK = 'disk'
    WEB = 'web'


class DocumentPermissionConst(object):
    COMMENT = 'comment'
    DOWNLOAD = 'download'
    EDIT = 'edit'
    FILL_FORMS = 'fillForms'
    PRINT = 'print'
    REVIEW = 'review'


AVAILABLE_TO_DISABLE_DOCUMENT_PERMISSIONS = {
    DocumentPermissionConst.COMMENT,
    DocumentPermissionConst.DOWNLOAD,
    DocumentPermissionConst.FILL_FORMS,
    DocumentPermissionConst.PRINT,
    DocumentPermissionConst.REVIEW
}
