# -*- coding: utf-8 -*-
"""

MPFS
CORE

Операции
для работы с aviary

"""
import time

from mpfs.common.static.codes import EXECUTING
from mpfs.core.address import Address
from mpfs.core.operations.base import Operation
from mpfs.core.queue import mpfs_queue
from mpfs.core.services.aviary_service import Aviary
from mpfs.core.operations.filesystem.copy import CopyAviaryDisk


class RenderPhotoAviary(Operation):
    """Редактирование изображения через авиари"""

    type = 'aviary'
    subtype = 'aviary_render'

    def __init__(self, **data):
        super(RenderPhotoAviary, self).__init__(**data)
        self.stages = []

    @classmethod
    def Create(cls, uid, odata, **kw):
        aviary = Aviary(request=None)
        resource = odata.pop('resource')
        aviary_job_id = aviary.render(resource, odata['actionlist'], override_url=odata.pop('override_url'))

        id = odata.get('id')
        mpfs_queue.put({
            'oid': id,
            'uid': uid,
            'aviary_job_id': aviary_job_id}, 'aviary_check_render_status', stime=time.time() + 1)

        odata['original_mid'] = resource.info()['this']['meta']['file_mid']
        odata['path'] = resource.visible_address.path
        odata['state'] = EXECUTING
        odata['aviary_job_id'] = aviary_job_id
        odata['target'] = CopyAviaryDisk.format_target_path(uid, resource.visible_address.path, odata.pop('time_suffix'))
        return super(RenderPhotoAviary, cls).Create(uid, odata, **kw)

    def is_render_finished(self):
        return self.dict().get('aviary_url') is not None

    def set_aviary_url(self, url):
        self.data['aviary_url'] = url

        original_file_mid = self.data.get('original_mid')
        target_path = self.data.get('target')

        target = Address.Make(self.uid, target_path)
        odata = dict(
            uid=target.uid,
            target=target.id,
            callback=self.data['callback'],
            connection_id=self.data['connection_id'],
            service_file_url=url,
            provider='aviary',
            force=True,
            render_operation_id=self.id
        )
        odata['mulca-id'] = original_file_mid

        op = self._create_operation(target, odata)
        self.data['download_operation_id'] = op.id

    @staticmethod
    def _create_operation(target, odata):
        from mpfs.core.operations import manager
        return manager.create_operation(
            target.uid,
            'social_copy',
            'aviary_disk',
            odata=odata
        )
