# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.common.static.codes import EXECUTING
from mpfs.core.services import zaberun_service
from mpfs.core.operations.base import Operation


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class BulkDownloadPrepare(Operation):
    type = 'download'
    subtype = 'bulk-download-prepare'

    @classmethod
    def Create(cls, uid, odata, **kw):
        download_url = zaberun_service.Zaberun().generate_zip_files_url(uid, odata['id'])
        odata['download_url'] = download_url
        odata['state'] = EXECUTING

        return super(BulkDownloadPrepare, cls).Create(uid, odata, **kw)
