# -*- coding: utf-8 -*-

import types

from mpfs.core.operations.base import Operation
from mpfs.core.event_dispatcher.events import Event


class OperationEvent(Event):
    """Базовое событие операций."""
    required_fields = (
        ('operation', Operation),
    )


class OperationCreatedEvent(OperationEvent):
    """Событие о создании операции."""
    required_fields = (
        ('connection_id', (types.NoneType, basestring)),
    )


class OperationBeforeCompletedEvent(OperationEvent):
    """Событие, срабатывающее прямо перед моментом изменения состояния операции
    на `~codes.COMPLETED`."""


class OperationBeforeDoneEvent(OperationEvent):
    """Событие, срабатывающее прямо перед моментом изменения состояния операции
    на `~codes.DONE`."""
