# -*- coding: utf-8 -*-
"""

MPFS
CORE

Разные работы с наследством 

"""
import traceback
import time

import mpfs.engine.process

from mpfs.common.util import logger
from mpfs.core.operations.base import Operation
from mpfs.core.filesystem.base import Filesystem
from mpfs.core.address import Address
from mpfs.core.user import base as user
from mpfs.common import errors
from mpfs.core.queue import mpfs_queue
from mpfs.common.static.tags import *
from mpfs.core.services.narod_service import OriginalNarod
from mpfs.core.filesystem.resources.narod import OriginalNarodFolder

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
lost_log = logger.get('mpfs.narod-lost')
# FIXME выянсить нужен ли этот логгер narod-lost и удалить
# Такого логгера не существует в конфигах. Скорее всего не используется уже
# Установил ему mpfs. Чтобы вдруг если, то сливались логи в корневой логгер

original_narod = OriginalNarod()

db = mpfs.engine.process.dbctl().database()

class MigrateNarodLegacy(Operation):
    '''
    Массовое копирование файлов с Народа в Диск
    '''
    
    type = 'legacy'
    subtype = 'narod'


    @classmethod
    def Create(classname, uid, odata, **kw):
        operation = super(MigrateNarodLegacy, classname).Create(uid, odata, **kw)
        
        try:
            user_obj = user.User(uid)
            #if user_obj.is_standart and user_obj.states.get('narod_migrated'):
            #    raise Exception("User %s already migrated. Remove narod_migrated setting if you really want to re-copy" % uid)
        except errors.StorageEmptyDiskInfo, e:
            user.Create(uid, type='standart', noemail=True)
        except errors.StorageInitUser, e:
            pass
        
        for user_type in ('standart', 'narod'):
            mpfs.engine.process.reset_cached()
            if int(user.NeedInit(uid, type=user_type, data=False)):
                user.Create(uid, type=user_type, noemail=True)
                    
        fs = Filesystem()
        legacy_addr = Address.Make(uid, '/narod')
        files = []
        
        good, diff, broken_size, broken_url = classname.TransferReport(uid)
        passed, failed, started = 0, 0, 0
        
        for item in diff + broken_size + broken_url:
            narod_id = item['id']
            filename = item['name']
            is_password = item['password']
            is_attach = item['is_attach']
            size = item['size']
            
            odata = {
                'source': Address.Make(uid, narod_id).id,
                'target': Address.Make(uid, '/lnarod/' + filename).id,
                'connection_id': '',
                'password': is_password,
                'allow_passworded': True,
            }
            
            try:
                from mpfs.core.operations.manager import create_operation
                sub_op = create_operation(uid, 'copy', 'narod_lnarod', odata)
            except errors.NarodNoResponse, e:
                sub_result = {
                    OID: None,
                    ID: narod_id,
                    NAME: filename,
                    STATUS: 'BAD FILE',
                    RESULT: None
                }
                failed = failed + 1
                log.info('FILE %s:%s (%s bytes) BAD OR FAILED' % (uid, filename, size))
                lost_log.info('%s:%s:%s (%s bytes) BAD OR FAILED' % (uid, narod_id, filename, size))
            except errors.ResourceBlocked, e:
                sub_result = {
                    OID: None,
                    ID: narod_id,
                    NAME: filename,
                    STATUS: 'BLOCKED FILE',
                    RESULT: None
                }
                passed = passed + 1
                log.info('FILE %s:%s (%s bytes) BLOCKED' % (uid, filename, size))
                lost_log.info('%s:%s:%s (%s bytes) BLOCKED' % (uid, narod_id, filename, size))
            else:
                log.info('FILE %s:%s (%s bytes) OP %s' % (uid, filename, size, sub_op.id))
                sub_result = {
                    OID: sub_op.id,
                    ID: narod_id,
                    NAME: filename,
                    STATUS: None,
                    RESULT: None
                }
                started = started + 1
                
            files.append(sub_result)
            
        operation.data[PROTOCOL] = files
        operation.data['counts'] = {
            'start': {'passed': passed, 'ok': started, 'fail': failed},
            'end': {'passed': passed, 'ok': 0, 'fail': failed}
        }
        operation.save()

        return operation

    def _process(self):
        if not (self.is_completed() or self.is_failed()):
            self.update_status()    
            self.reenque(10)

    def update_status(self):
        from mpfs.core.operations.manager import get_operation
        
        success_or_failed = self.is_done() or self.is_completed() or self.is_failed()
        
        if not success_or_failed:
            all_completed_or_failed = True
            
            for item in self.data[PROTOCOL]:
                if item.get('oid'):
                    op = get_operation(self.uid, item['oid'])
                    item[STATUS] = op.state
                    if not(op.is_failed() or op.is_completed() or op.is_done()):
                        all_completed_or_failed = False
            self.save()
            
            if all_completed_or_failed:
                self.set_done()
        
        if self.is_done() and not self.is_completed():
            mpfs.engine.process.reset_cached()
            try:
                if self.data['update_narod']:
                    OriginalNarod().set_user_moved(self.uid)
                if self.data['update_disk']:
                    user.User(self.uid).set_state(key='narod_migrated', value=1)
            except Exception:
                error_log.error(traceback.format_exc())
            else:
                self.set_completed()
                
                for item in self.data[PROTOCOL]:
                    if item.get('oid'):
                        op = get_operation(self.uid, item['oid'])
                        if op.is_failed():
                            self.data['counts']['end']['fail'] += 1
                        if op.is_completed() or op.is_done():
                            self.data['counts']['end']['ok'] += 1
                self.save()
                
                if self.data['counts']['end']['ok'] == self.data['counts']['start']['ok']:
                    final_status = 'PROCESSED'
                else:
                    final_status = 'FAILED'
                    db.narod_migrate_failed.update({'_id': int(self.uid)}, {'_id': int(self.uid)}, upsert=True)
                    
                log.info('NAROD %s %s | OP: %s | COUNTS: %s | PARAMS: c:%s n:%s d:%s' % \
                    (self.uid, final_status, self.id, self.data['counts'], self.data['copy'], self.data['update_narod'], self.data['update_disk']))
            
    
    def get_status(self):
        result = super(MigrateNarodLegacy, self).get_status()
        result[PROTOCOL] = self.data[PROTOCOL]
        result['counts'] = self.data['counts']
        return result
    
    
    @classmethod
    def TransferReport(classname, uid):
        mpfs.engine.process.reset_cached()
        
        fs = Filesystem()
        
        legacy_addr = Address.Make(uid, '/narod')
        moved_addr = Address.Make(uid, '/lnarod')
        
        legacy = {}
        legacy_links = {}
        moved_by_namesize = {}
        moved_by_name = {}
        
        diff = []
        broken_size = []
        broken_url = []
        good = []
        
        for item in original_narod.list_moved_files(uid):
            legacy_links[item['hash']] = unicode(item['url'])
    
        for item in OriginalNarodFolder(uid, legacy_addr, None).list()['list']:
            if item['type'] == 'dir':
                continue
            
            chunks = item['id'].split('/')
            info = {
                'id': item['id'],
                'hash': chunks[2],
                'size': item['size'],
                'name': item['name'],
                'password': item['meta']['pass'] != '',
                'is_attach': item['meta']['parent'] == '1',
                'encoded_name': item['name'].encode('utf-8') if isinstance(item['name'], unicode) else item['name'],
            }
            
            legacy['%s_%s' % (info['encoded_name'], info['size'])] = info
            
    
        for item in fs.content(uid, moved_addr.id, None)['list']:
            if item['type'] == 'dir':
                continue
            
            info = {
                'id': item['id'],
                'name': item['name'],
                'size': item['size'],
                'encoded_name': item['name'].encode('utf-8') if isinstance(item['name'], unicode) else item['name'],
                'url': item['meta'].get('short_url')
            }
            moved_by_namesize['%s_%s' % (info['encoded_name'], info['size'])] = info
            moved_by_name['%s' % info['encoded_name']] = info
                    
        """
        Мутный алгоритм сверки
        Сверяем все имеющиеся файлы в Народе с файлами из /lnarod
        
        GOOD - 100% перенесенцы.
        DIFF - 100% неперенесенцы.
        BROKEN_SIZE - перенесенцы, но размер не совпадает. Повтору не подлежит.
        BROKEN_URL - перенесенец, но урл показывает не туда. Подлежит повторному переносу.  
        
        Запускаем сверку:
            сверить файл по имени-размеру:
                если не нашлось - сверить по имени
                    если не нашлось по имени - заносим в DIFF
                    если нашлось по имени - возможно битый размер - заносим в BROKEN_SIZE
                если нашлось - проверить урл:
                    если файл запаролен, то автоматом в GOOD
                    если не запаролен и урл совпадает - в GOOD
                    если не запаролен и урл не совпал - заносим в BROKEN_URL
                
        """
        for key, item in legacy.iteritems():
            if key not in moved_by_namesize:
                if item['name'] not in moved_by_name:
                    diff.append(item)
                else:
                    broken_size.append(item)
            else:
                moved_info = moved_by_namesize[key]
                item['dst'] = moved_info['id'].encode('utf-8') if isinstance(moved_info['id'], unicode) else moved_info['id']
                
                if not item['password']:
                    nhash = item['hash']
                    if nhash in legacy_links and moved_info['url'] == legacy_links[nhash]:
                        good.append(item)
                    else:
                        broken_url.append(item)
                else:
                    good.append(item)
           
        return (good, diff, broken_size, broken_url)
    

        
