# -*- coding: utf-8 -*-

from collections import defaultdict
from mpfs.config import settings
from mpfs.core.operations.dao.operation import OperationDAO
from mpfs.core.operations import manager
from mpfs.common.static.codes import WAITING, EXECUTING

OP_TYPES_SUBTYPES = defaultdict(list)
OP_STATES = (WAITING, EXECUTING)
COMMON_OPERATIONS = settings.frozen_operations_monitoring['common_operations']


class OperationSignificance(object):
    common = 'common'
    important = 'important'

OP_MAX_AGE = {
    OperationSignificance.common: settings.frozen_operations_monitoring['alert_age']['common'],
    OperationSignificance.important: settings.frozen_operations_monitoring['alert_age']['important'],
}

for operation, opts in settings.operations['types'].iteritems():
    if not opts.get('pended'):
        continue
    significance = OperationSignificance.common if operation in COMMON_OPERATIONS else OperationSignificance.important
    for operation_subtype in opts['pended']:
        OP_TYPES_SUBTYPES[significance].append((operation, operation_subtype))


def get_frozen_operations_count(op_significance):
    age_limit = OP_MAX_AGE[op_significance]
    return OperationDAO().get_count_by_age_types_subtypes_and_states(age_limit, OP_TYPES_SUBTYPES[op_significance],
                                                                     OP_STATES)


def fetch_frozen_operations(op_significance):
    age_limit = OP_MAX_AGE[op_significance]
    dao_items_gen = OperationDAO().fetch_by_age_types_subtypes_and_states(age_limit, OP_TYPES_SUBTYPES[op_significance],
                                                                          OP_STATES)
    for dao_item in dao_items_gen:
        yield manager.get_operation(dao_item.uid, dao_item.id)


def get_frozen_important_operations_count():
    return get_frozen_operations_count(OperationSignificance.important)


def get_frozen_common_operations_count():
    return get_frozen_operations_count(OperationSignificance.common)


def fetch_frozen_important_operations():
    return fetch_frozen_operations(OperationSignificance.important)


def fetch_frozen_common_operations():
    return fetch_frozen_operations(OperationSignificance.common)
