# -*- coding: utf-8 -*-
"""

MPFS
CORE

Операции
для работы с пользователем

"""
import mpfs.engine.process

from mpfs.common.errors import StorageKeyNotFound
from mpfs.common import errors
from mpfs.core.filesystem.dao.legacy import CollectionRoutedDatabase
from mpfs.core.operations.base import Operation
from mpfs.core.bus import Bus
from mpfs.core.user.base import User
from mpfs.core.billing.processing import repair


class UserRemove(Operation):
    '''Удаление пользователя'''

    type = 'user'
    subtype = 'remove'

    @classmethod
    def Create(classname, uid, odata, **kw):
        user = User(uid)

        if user.is_b2b() is False and odata['req_type'] != 'service':
            raise errors.UserRemoveNotAllowed()

        return super(UserRemove, classname).Create(uid, odata, **kw)

    def _process(self, *args, **kwargs):
        db = CollectionRoutedDatabase()

        # Удаляем файлы
        bus = Bus()
        for func in (lambda: bus.rm(self.uid, '%s:/disk' % self.uid),
                     lambda: bus.rm(self.uid, '%s:/attach' % self.uid),
                     lambda: bus.trash_drop_all(self.uid, self.uid)):
            try:
                func()
            except StorageKeyNotFound:
                # пустое пространство - удалять нечего
                pass

        # Проставляем пользователю флаг удалённости
        User(self.uid).set_deleted()

        # Удаляем метаданные
        db.album_items.remove({"uid": self.uid})
        db.albums.remove({"uid": self.uid})
        db.billing_orders.remove({"uid": self.uid})
        db.billing_orders_history.remove({"uid": self.uid})
        db.billing_service_attributes.remove({"uid": self.uid})
        db.billing_service_attributes_history.remove({"uid": self.uid})
        db.billing_services.remove({"uid": self.uid})
        db.billing_services_history.remove({"uid": self.uid})
        db.billing_subscriptions.remove({"uid": self.uid})
        db.group_invites.remove({"uid": self.uid})
        db.group_links.remove({"uid": self.uid})
        db.groups.remove({"owner": self.uid})
        db.invite_mpfs_referrals.remove({"_id": self.uid})
        db.invite_mpfs_sent.remove({"uid": self.uid})
        db.link_data.remove({"uid": self.uid})

        # Пересчитываем место и выставляем квоту
        repair.recalculate_limit_by_services(self.uid)

        self.set_completed()


# handled in djfs-worker
class UserPreliminaryDelete(Operation):
    type = 'user'
    subtype = 'preliminary_delete'
    task_name = 'user_preliminary_delete_operation'


# handled in djfs-worker
class UserPermanentDelete(Operation):
    type = 'user'
    subtype = 'permanent_delete'
    task_name = 'user_permanent_delete_operation'
