# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.common.util import from_json
from mpfs.core.organizations import logic


log = mpfs.engine.process.get_default_log()


def organization_event(req):
    """Обработать событие в Директории.

    Директория на создание организации и изменение платности присылает события вида

    {
        "content": {},
        "event": "organization_added",
        "obj": {
            "id": 12
        },
        "org_id": 12,
        "revision": 1522
    }

    {
        "content": {
            "subscription_plan": "paid"
        },
        "event": "organization_subscription_plan_changed",
        "obj": {
            "id": 12
        },
        "org_id": 12,
        "revision": 1522
    }

    Просили не завязыватсья на наличие объектов content или obj: https://st.yandex-team.ru/CHEMODAN-36485#1499880407000
    """
    event = from_json(req.http_req.data)
    organization_id = str(event['org_id'])
    log.info('Got Directory event for organization ' + organization_id)
    logic.update_organization_async(organization_id)
    return {}
