# -*- coding: utf-8 -*-
from mpfs.core.organizations.logic import calculate_organization_used_space, update_organization
from mpfs.engine.queue2.celery import BaseTask, app


@app.task(base=BaseTask)
def handle_calculate_organization_used_space(organization_id, context=None, **kwargs):
    calculate_organization_used_space(organization_id)


@app.task(base=BaseTask)
def handle_update_organization(organization_id, context=None, **kwargs):
    update_organization(organization_id)


@app.task(base=BaseTask)
def handle_update_b2b_key(uid, context=None, **kwargs):
    import mpfs.engine.process
    from mpfs.core.user.base import User
    from mpfs.core.services.directory_service import DirectoryService
    usrctl = mpfs.engine.process.usrctl()
    user = User(uid)
    if not user.b2b_key:
        orgs = DirectoryService().get_organizations_by_uids([uid]).get(uid, [])
        if orgs:
            usrctl.update(user.uid, user.type, user.get_supported_locale(), str(orgs[0]['id']))
