# -*- coding: utf-8 -*-
import click


@click.command('create_overdraft_cleaner_tasks', help=u"Проставить таски на удаление пользователя из овердрафта")
def create_overdraft_cleaner_tasks():
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()
    from mpfs.core.overdraft import tasks
    tasks.create_overdraft_cleaner_tasks()


@click.command('overdraft_cleaner_worker', help=u'Проверка пользователя на овердрафт и удаление его из таблицы если он не в нем')
@click.argument('uid', nargs=1)
def overdraft_cleaner_worker(uid):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.overdraft.logic.overdraft_cleaner import BazingaOverdraftCleanerWorker
    BazingaOverdraftCleanerWorker(uid).run()


@click.command('create_overdraft_send_message_tasks', help=u"Проставить таски на отправку писем юзерам из овердрафта")
def create_overdraft_send_message_tasks():
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()
    from mpfs.core.overdraft import tasks
    tasks.create_overdraft_send_message_tasks()


@click.command('overdraft_send_message_worker', help=u'Отправка писем юзерам из овердрафта')
@click.argument('uid', nargs=1)
def overdraft_send_message_worker(uid):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.overdraft.logic.overdraft_send_message import BazingaOverdraftSendMessageWorker
    BazingaOverdraftSendMessageWorker(uid).run()


@click.group()
def overdraft():
    pass


overdraft.add_command(create_overdraft_cleaner_tasks)
overdraft.add_command(create_overdraft_send_message_tasks)
overdraft.add_command(overdraft_cleaner_worker)
overdraft.add_command(overdraft_send_message_worker)
