# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.common import errors
from mpfs.config import settings
from mpfs.core.billing.dao.overdraft import OverdraftDAO
from mpfs.core.services.bazinga_service import OnetimeTask
from mpfs.core.user.base import User

OVERDRAFT_CLEANER_WORKER_ENABLED = settings.user['overdraft']['cleaner']['worker']['enabled']
OVERDRAFT_CLEANER_WORKER_DRY_RUN = settings.user['overdraft']['cleaner']['worker']['dry_run']


class BazingaOverdraftCleanerWorker(OnetimeTask):
    log = mpfs.engine.process.get_default_log()
    error_log = mpfs.engine.process.get_error_log()

    ENABLED = OVERDRAFT_CLEANER_WORKER_ENABLED
    DRY_RUN = OVERDRAFT_CLEANER_WORKER_DRY_RUN
    BAZINGA_TASK_NAME = 'OverdraftCleanerWorker'

    def __init__(self, uid):
        super(BazingaOverdraftCleanerWorker, self).__init__()
        if not isinstance(uid, basestring):
            raise TypeError('OverdraftCleanerWorker parameter type is incorrect: %s' % type(uid))
        self.uid = uid

    def build_command_parameters(self):
        return [self.uid]

    def run(self):
        if not self.ENABLED:
            self.log.info('Disabled. Check config')
            return

        if not self.uid:
            self.log.info('No user id')
            return

        try:
            user = User(self.uid)
        except errors.StorageInitUser as e:
            self.error_log.info('User %s initialization failed with exception %s' % (self.uid, e))
            return

        if not user.is_in_overdraft_for_restrictions():
            self.log.info('User %s is deleted from overdraft table' % self.uid)
            if not self.DRY_RUN:
                OverdraftDAO().delete(self.uid)
