import click

import mpfs.engine.process
from mpfs.config import settings
from mpfs.core.billing.dao.overdraft import OverdraftDAO
from mpfs.core.overdraft.logic.overdraft_cleaner import BazingaOverdraftCleanerWorker
from mpfs.core.overdraft.logic.overdraft_send_message import BazingaOverdraftSendMessageWorker
from mpfs.core.services.bazinga_service import BazingaInterface

log = mpfs.engine.process.get_default_log()

OVERDRAFT_CLEANER_ENABLED = settings.user['overdraft']['cleaner']['create_tasks_enabled']


def create_overdraft_cleaner_tasks():
    if not OVERDRAFT_CLEANER_ENABLED:
        click.echo('create_overdraft_cleaner_tasks disabled')
        return

    _create_tasks('last_send_cleaner_handle_date', BazingaOverdraftCleanerWorker)


def create_overdraft_send_message_tasks():
    _create_tasks('last_send_email_handle_date', BazingaOverdraftSendMessageWorker)


def _create_tasks(field_for_iter, task):
    overdraft_dao = OverdraftDAO()
    while True:
        uids = [str(x.uid) for x in overdraft_dao.get_all_by_chunks(field_for_iter, 1000)]
        log.info('Found %s uids', len(uids))
        if len(uids) == 0:
            return

        tasks_count = len(BazingaInterface().bulk_create_tasks([task(uid) for uid in uids]))
        log.info('Create %s tasks', tasks_count)

        overdraft_dao.update_iter_field(uids, field_for_iter)
