# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.core.support import comment

log = mpfs.engine.process.get_default_log()


def check_space_and_unblock_overdrafter(uid):
    from mpfs.core.user.base import User

    user = User(uid)
    if user.is_blocked() and not user.is_in_overdraft_for_restrictions() and is_block_by_overdraft(uid):
        user.set_block(False, 'Unblock after buy service')


def is_block_by_overdraft(uid):
    block_comments = get_block_messages(uid)
    if len(block_comments) == 0:
        return False
    return block_comments[0] == 'blocked for overdraft'


def get_block_messages(uid):
    comments = comment.select(uid)
    comments.reverse()

    return [c['comment'] for c in comments if c['type'] == 'block_user']
