# -*- coding: utf-8 -*-
from mpfs.common.util import from_json, type_to_bool


class PhotosliceAlbumTypeDataStructure(object):
    device_original_path = None
    device_collections = None
    client_etime = None
    user_agent = None
    upload_raw_path = None
    is_screenshot = None

    def __init__(
            self, device_original_path, device_collections, client_etime, user_agent, upload_raw_path, is_screenshot):
        self.device_original_path = device_original_path
        self.device_collections = device_collections
        self.client_etime = client_etime
        self.user_agent = user_agent
        self.upload_raw_path = upload_raw_path
        self.is_screenshot = is_screenshot

    @classmethod
    def cons_by_params(cls, device_original_path, device_collections, etime, user_agent, path, changes):
        return cls(
            device_original_path,
            from_json(device_collections) if device_collections else None,
            int(etime) if etime else None,
            user_agent,
            path,
            type_to_bool(changes['screenshot']) if changes.get('screenshot') is not None else None
        )

    @classmethod
    def cons_of_dict(cls, data_dict):
        if not data_dict:
            return None
        return cls(data_dict['device_original_path'], data_dict['device_collections'], data_dict['client_etime'],
                   data_dict['user_agent'], data_dict['upload_raw_path'], data_dict['is_screenshot'])
