# -*- coding: utf-8 -*-
"""

MPFS
PHOTOSLICE

"""
import mpfs.engine.process

from mpfs.config import settings
from mpfs.core.services.search_service import DiskSearch
from mpfs.core.services.disk_service import Disk
from mpfs.core.factory import get_resources_with_dummies, get_resources
from mpfs.core.address import Address

disk_search = DiskSearch()
disk_service = Disk()

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


def periods_counts(req):
    version = disk_service.get_version(req.uid)
    result = disk_search.list_periods_counts(req.uid, version)
    result['version'] = version
    return result


def periods_ids(req):
    version = disk_service.get_version(req.uid)
    result = disk_search.list_periods_ids(req.uid, version)
    result['version'] = version
    return result


def resources(req):
    """
    Выдать список ресурсов по данным из поискового кластеризатора
    Если ресурса в диске уже нет, то выдать заглушку, см. https://st.yandex-team.ru/CHEMODAN-21299

    :param req: obj запрос
    :return: dict в котором есть объект списка ресурсов
    """
    cluster_list = disk_search.list_resources(req.uid, req.version, req.amount, req.offset)

    addresses, dummies = [], []
    for item in cluster_list:
        key, file_id = item.get('key'), item.get('id')

        address = Address.Make(req.uid, key)
        dummy = {
            "photoslice_lost": True,
            "meta": {
                "file_id": file_id,
            },
            "path": address.path,
            "type": "file",
            "id": address.path,
            "name": address.name
        }

        addresses.append(address)
        dummies.append(dummy)

    version = disk_service.get_version(req.uid)
    resources_list = []
    if addresses:
        if settings.feature_toggles['photoslice_dummies']:
            resources_list = get_resources_with_dummies(req.uid, addresses, dummies)
        else:
            resources_list = get_resources(req.uid, addresses)
    return {'version': version, 'list': resources_list}
