# -*- coding: utf-8 -*-
"""
Каталог продуктов по промокодам
"""
from mpfs.common.static import SPACE_1GB
from mpfs.common.static.tags.billing import *


promo_code_products = [
    # https://st.yandex-team.ru/CHEMODAN-41291
    {
        ID: 'euroset_1tb_1_year',
        NAME: {
            RU_RU: u'Евросеть',
            UK_UA: u'Euroset',
            EN_EN: u'Euroset',
            TR_TR: u'Euroset',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41282
    {
        ID: 'wikium_100_gb_1_year',
        NAME: {
            RU_RU: u'Wikium',
            UK_UA: u'Wikium',
            EN_EN: u'Wikium',
            TR_TR: u'Wikium',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41480
    {
        ID: 'promo_code_blat_100',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-55538
    {
        ID: 'promo_code_blat_100gb_1m',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-55538
    {
        ID: 'promo_code_blat_1tb_1m',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 40,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41412
    {
        ID: 'beeline_armenia_20gb',
        NAME: {
            RU_RU: u'Beeline.Армения',
            UK_UA: u'Beeline.Вірменія',
            EN_EN: u'Beeline.Armenia',
            TR_TR: u'Beeline.Ermenistan',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 20,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41412
    {
        ID: 'beeline_armenia_30gb',
        NAME: {
            RU_RU: u'Beeline.Армения',
            UK_UA: u'Beeline.Вірменія',
            EN_EN: u'Beeline.Armenia',
            TR_TR: u'Beeline.Ermenistan',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 30,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41412
    {
        ID: 'beeline_armenia_40gb',
        NAME: {
            RU_RU: u'Beeline.Армения',
            UK_UA: u'Beeline.Вірменія',
            EN_EN: u'Beeline.Armenia',
            TR_TR: u'Beeline.Ermenistan',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 40,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41412
    {
        ID: 'beeline_armenia_50gb',
        NAME: {
            RU_RU: u'Beeline.Армения',
            UK_UA: u'Beeline.Вірменія',
            EN_EN: u'Beeline.Armenia',
            TR_TR: u'Beeline.Ermenistan',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 50,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41501
    {
        ID: 'webmaster_competition_joke_30gb',
        NAME: {
            RU_RU: u'Конкурс – Шутка',
            UK_UA: u'Конкурс - Жарт',
            EN_EN: u'Competition - Joke',
            TR_TR: u'Rekabet - Şaka',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 30,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41501
    {
        ID: 'webmaster_blat_50gb',
        NAME: {
            RU_RU: u'Друзьям Диска',
            UK_UA: u'Друзіям Диска',
            EN_EN: u'For Disk\'s friends',
            TR_TR: u'Arkadaşları',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 50,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41501
    {
        ID: 'webmaster_blat_100gb',
        NAME: {
            RU_RU: u'Друзьям Диска',
            UK_UA: u'Друзіям Диска',
            EN_EN: u'For Disk\'s friends',
            TR_TR: u'Arkadaşları',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41781
    {
        ID: 'spring_gigabytes_10gb_2018',
        NAME: {
            RU_RU: u'Весенние гигабайты',
            UK_UA: u'Весняні гігабайти',
            EN_EN: u'Spring gigabytes',
            TR_TR: u'Bahar gigabayt',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 10,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-42922
    {
        ID: 'telegram_10gb_2018',
        NAME: {
            RU_RU: u'Гигабайтов много не бывает',
            UK_UA: u'Гигабайтов много не бывает',
            EN_EN: u'Гигабайтов много не бывает',
            TR_TR: u'Гигабайтов много не бывает',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 10,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-41815
    {
        ID: 'samsung_kazakhstan_2018',
        NAME: {
            RU_RU: u'Samsung Members',
            UK_UA: u'Samsung Members',
            EN_EN: u'Samsung Members',
            TR_TR: u'Samsung Members',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 10,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-43278
    {
        ID: 'yac_2018_participant_100gb_eternal',
        NAME: {
            RU_RU: u'За участие в конференции YaC',
            UK_UA: u'За участь у конференції YaC',
            EN_EN: u'For participating in YaC',
            TR_TR: u'YaC konferansına katıldığınız için',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-43278
    {
        ID: 'yac_2018_participant_100gb_1y',
        NAME: {
            RU_RU: u'За участие в конференции YaC',
            UK_UA: u'За участь у конференції YaC',
            EN_EN: u'For participating in YaC',
            TR_TR: u'YaC konferansına katıldığınız için',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-44680
    {
        ID: 'megafon_100gb_1m_2018',
        NAME: {
            RU_RU: u'Пользователям Мегафона',
            UK_UA: u'Для користувачів Мегафона',
            EN_EN: u'For Megafon users',
            TR_TR: u'Megafon kullanıcıları için',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-44680
    {
        ID: 'megafon_1tb_1m_2018',
        NAME: {
            RU_RU: u'Пользователям Мегафона',
            UK_UA: u'Для користувачів Мегафона',
            EN_EN: u'For Megafon users',
            TR_TR: u'Megafon kullanıcıları için',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 40,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-56049
    {
        ID: 'megafon_100gb_6m_2018',
        NAME: {
            RU_RU: u'Пользователям Мегафона',
            UK_UA: u'Для користувачів Мегафона',
            EN_EN: u'For Megafon users',
            TR_TR: u'Megafon kullanıcıları için',
        },
        PERIOD: {
            MONTH: 6
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-56049
    {
        ID: 'megafon_1tb_6m_2018',
        NAME: {
            RU_RU: u'Пользователям Мегафона',
            UK_UA: u'Для користувачів Мегафона',
            EN_EN: u'For Megafon users',
            TR_TR: u'Megafon kullanıcıları için',
        },
        PERIOD: {
            MONTH: 6
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 40,
        },
        ALTATTRS: False,
    },
    # факап с промокодом DISK2019
    {
        ID: 'disk_ny_2019_10gb_1m',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзям Яндекса',
            EN_EN: u'For friends of Yandex',
            TR_TR: u'Yandex dostları için',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 10,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-44382
    {
        ID: 'test_megafon_100gb_1m',
        NAME: {
            RU_RU: u'Тест для Мегафона',
            UK_UA: u'Тест для Мегафона',
            EN_EN: u'Тест для Мегафона',
            TR_TR: u'Тест для Мегафона',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 30 * 100,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-44382
    {
        ID: 'test_megafon_1tb_1m',
        NAME: {
            RU_RU: u'Тест для Мегафона',
            UK_UA: u'Тест для Мегафона',
            EN_EN: u'Тест для Мегафона',
            TR_TR: u'Тест для Мегафона',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 ** 40,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_promo_code_1kb_2min',
        NAME: {
            RU_RU: u'ТЕСТ: килобайт по промокоду на 2 минуты',
            UK_UA: u'ТЕСТ: килобайт по промокоду на 2 минуты',
            EN_EN: u'ТЕСТ: 1kb by promo code for 2 mins',
            TR_TR: u'ТЕСТ: 1kb by promo code for 2 mins',
        },
        PERIOD: {
            SECOND: 120
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_promo_code_1kb_1m',
        NAME: {
            RU_RU: u'ТЕСТ: килобайт по промокоду на 1 месяц',
            UK_UA: u'ТЕСТ: килобайт по промокоду на 1 месяц',
            EN_EN: u'ТЕСТ: 1kb by promo code for 1 month',
            TR_TR: u'ТЕСТ: 1kb by promo code for 1 month',
        },
        PERIOD: {
            MONTH: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_promo_code_1kb_1y',
        NAME: {
            RU_RU: u'ТЕСТ: килобайт по промокоду на 1 год',
            UK_UA: u'ТЕСТ: килобайт по промокоду на 1 год',
            EN_EN: u'ТЕСТ: 1kb by promo code for 1 year',
            TR_TR: u'ТЕСТ: 1kb by promo code for 1 year',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_promo_code_1kb_eternal',
        NAME: {
            RU_RU: u'ТЕСТ: килобайт по промокоду вечная',
            UK_UA: u'ТЕСТ: килобайт по промокоду вечная',
            EN_EN: u'ТЕСТ: 1kb by promo code eternal',
            TR_TR: u'ТЕСТ: 1kb by promo code eternal',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_assessor_promo_code_service',
        NAME: {
            RU_RU: u'ТЕСТ: услуга для ассессоров',
            UK_UA: u'ТЕСТ: услуга для ассессоров',
            EN_EN: u'TEST: service for assessors',
            TR_TR: u'TEST: service for assessors',
        },
        PERIOD: {
            SECOND: 60
        },
        AUTO: False,
        PROLONGABLE: False,
        PRICE: {USD: 0, RUB: 0},
        INAPP: False,
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: -1,
        },
        ALTATTRS: False,
    },
    {
        ID: '5tb_1y_blogger',
        NAME: {
            RU_RU: u'5 ТБ на год',
            UK_UA: u'5 ТБ на рік',
            EN_EN: u'5 TB for a year',
            TR_TR: u'Yıllık 5 TB',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 5497558138880,
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_eternal',
        NAME: {
            RU_RU: u'Диск - прошлое, настоящее, будущее',
            UK_UA: u'Диск - прошлое, настоящее, будущее',
            EN_EN: u'Диск - прошлое, настоящее, будущее',
            TR_TR: u'Диск - прошлое, настоящее, будущее',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
        },
        ALTATTRS: False,
    },
    {
        ID: '1tb_eternal_friends',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзьям Яндекса',
            EN_EN: u'Друзьям Яндекса',
            TR_TR: u'Друзьям Яндекса',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1099511627776,
        },
        ALTATTRS: False,
    },
    {
        ID: '100gb_eternal_friends',
        NAME: {
            RU_RU: u'Друзьям Яндекса',
            UK_UA: u'Друзьям Яндекса',
            EN_EN: u'Друзьям Яндекса',
            TR_TR: u'Друзьям Яндекса',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 107374182400,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-73914
    {
        ID: 'beeline_256gb_1_year',
        NAME: {
            RU_RU: u'+256 ГБ на 1 год',
            UK_UA: u'+256 ГБ на 1 год',
            EN_EN: u'+256 ГБ на 1 год',
            TR_TR: u'+256 ГБ на 1 год',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 256 * SPACE_1GB,
        },
        ALTATTRS: False,
    },
    # https://st.yandex-team.ru/CHEMODAN-75080
    {
        ID: 'championship_prize_winner_200gb_1_year',
        NAME: {
            RU_RU: u'Призер Чемпионата',
            UK_UA: u'Призер Чемпионата',
            EN_EN: u'Призер Чемпионата',
            TR_TR: u'Призер Чемпионата',
        },
        PERIOD: {
            MONTH: 12
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 200 * SPACE_1GB,
        },
        ALTATTRS: False,
    },
]

promo_code_products_dev = [
    {
        ID: 'test_promo_code_1kb',
        NAME: {
            RU_RU: u'ТЕСТ: килобайт по промокоду',
            UK_UA: u'ТЕСТ: килобайт по промокоду',
            EN_EN: u'ТЕСТ: 1kb by promo code',
            TR_TR: u'ТЕСТ: 1kb by promo code',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
    {
        ID: 'test_promo_code_1kb_5sec',
        NAME: {
            RU_RU: u'ТЕСТ: килобайт по промокоду на 5 секнунд',
            UK_UA: u'ТЕСТ: килобайт по промокоду на 5 секнунд',
            EN_EN: u'ТЕСТ: 1kb by promo code for 5 sec',
            TR_TR: u'ТЕСТ: 1kb by promo code for 5 sec',
        },
        PERIOD: {
            SECOND: 5
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 1024,
        },
        ALTATTRS: False,
    },
]
