# -*- coding: utf-8 -*-
import click

help_doc = u"""
Сгенерировать набор промокодов по выбранной услуге и времени действия.
Примеры:

* генерация нескольких промокодов на услугу
mpfs-cli promo_codes generate 100 999999999 --codes_num 10 --pid test_promo_code_1kb_2min

* генерация промокода с заданным именем и множественной активацией на скидку
mpfs-cli promo_codes generate 100 999999999 --activation_num 1000 --code_id QWERTY --discount_template_id FFFF

"""


@click.command(help=help_doc)
@click.argument('begin_timestamp', type=click.IntRange(0))
@click.argument('end_timestamp', type=click.IntRange(0))
@click.option('--activation_num', default=1, type=click.IntRange(1, 10**9), help=u'Количество активаций')
@click.option('--code_id', default=None, type=click.STRING, help=u'Указать конкретное имя промокода')
@click.option('--codes_num', default=1, type=click.IntRange(1, 10**6), help=u'Количество промокодов для генерации')
@click.option('--pid', default=None, help=u'product_id, для генерации промокодов на услуги')
@click.option('--discount_template_id', default=None, help=u'discount_template_id, для генерации промокодов на скидки')
def generate(begin_timestamp, end_timestamp, activation_num, code_id, codes_num, pid, discount_template_id):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()

    from mpfs.core.promo_codes.logic.code_generator import PromoCodeGeneratorFactory

    if pid is None and discount_template_id is None or pid and discount_template_id:
        raise ValueError('Need to specify either --pid or --discount_id')
    if code_id and codes_num > 1:
        raise ValueError('You can pass code_id only if code_num == 1 (default value)')
    generator = PromoCodeGeneratorFactory.get_generator(pid=pid,
                                                        discount_template_id=discount_template_id,
                                                        begin_timestamp=begin_timestamp,
                                                        end_timestamp=end_timestamp,
                                                        activation_num=activation_num)

    for i in range(codes_num):
        try:
            new_code = generator.generate_and_insert_promo_code(code_id)
        except Exception, e:
            click.echo('ERROR: failed to insert %s %s' % (e.__class__.__name__, e))
            raise
        click.echo(new_code)
