# -*- coding: utf-8 -*-
from mpfs.common.util.experiments.logic import experiment_manager
from mpfs.core.db_rps_limiter import InDBRPSLimiter
from mpfs.core.metastorage.decorators import user_exists_and_not_blocked
from mpfs.core.promo_codes.logic.errors import TooManyAttemptsToActivatePromoCode
from mpfs.core.promo_codes.logic.promo_code_manager import PromoCodeManager


@user_exists_and_not_blocked
def promo_code_activate(req):
    """Активировать промокод

    Если промокод есть в базе среди активных и он не использован, то добавляет пользователю услугу. Если использовались
    все его активации, то логирует событие и удаляет промокод из активных. Если промокода нет или акция по данному
    промокод  у уже была использована - вернет 409. Имеет ограничение на 10 запрсоов в сутки.

    Query string аргументы:
        * uid [обязательный] - uid пользователя, который собирается активировать промокод.
        * promo_code [обязательный]
    """

    if not experiment_manager.is_feature_active('disable_promo_code_rate_limiter'):
        ratelimit = InDBRPSLimiter('promo_code_activate')
        if not ratelimit.check_limit_and_increment_counter(req.uid):
            raise TooManyAttemptsToActivatePromoCode()

    return PromoCodeManager.find_and_activate_promo_code(req.uid, req.promo_code.upper())
