# -*- coding: utf-8 -*-
from dateutil.relativedelta import relativedelta

from mpfs.config import settings
from mpfs.core.queue import mpfs_queue
from mpfs.engine.process import get_default_log

PROMO_COME_BACK_USER_DISCOUNT_MINIMUM_DIFFERENCE_IN_MONTHS = settings.promo['come_back_user_discount']['minimum_difference_in_months']
PROMO_COME_BACK_USER_DISCOUNT_BLACK_LIST = set(settings.promo['come_back_user_discount']['black_list'])
FEATURE_TOGGLES_COMEBACK_USER_DISCOUNT_ENABLED = settings.feature_toggles['comeback_user_discount_enabled']

default_log = get_default_log()


def provide_discount_if_needed(uid, previous_activity_date, current_activity_date):
    if not FEATURE_TOGGLES_COMEBACK_USER_DISCOUNT_ENABLED:
        return

    if uid in PROMO_COME_BACK_USER_DISCOUNT_BLACK_LIST:
        default_log.info('user\'s is blacklisted, no discount for him uid=%s' % uid)
        return

    if previous_activity_date is None:
        mpfs_queue.put({'uid': uid}, 'provide_discount_to_come_back_user')
        return

    rd = relativedelta(current_activity_date, previous_activity_date)
    if rd.years * 12 + rd.months >= PROMO_COME_BACK_USER_DISCOUNT_MINIMUM_DIFFERENCE_IN_MONTHS:
        mpfs_queue.put({'uid': uid}, 'provide_discount_to_come_back_user')
        return
