# -*- coding: utf-8 -*-
from mpfs.common.errors import MPFSError
from mpfs.common.static import codes


class UserAlreadyHasSuchPromoService(MPFSError):
    response = 409
    code = codes.USER_ALREADY_HAS_SUCH_PROMO_SERVICE
    message = 'Can\'t activate promo code because user already has such service'


class AttemptToActivateUsedPromoCode(MPFSError):
    response = 409
    code = codes.ATTEMPT_TO_ACTIVATE_USED_PROMO_CODE
    message = 'Can\'t activate promo code because someone already used this promo code'


class PromoCodeNotFound(MPFSError):
    response = 404
    code = codes.PROMO_CODE_NOT_FOUND
    message = 'Promo code not found'


class TooEarlyPromoCodeActivation(MPFSError):
    response = 404
    code = codes.TOO_EARLY_PROMO_CODE_ACTIVATION
    message = 'Promo of provided promo code is not active yet'


class TooLatePromoCodeActivation(MPFSError):
    response = 404
    code = codes.TOO_LATE_PROMO_CODE_ACTIVATION
    message = 'Promo of provided promo code is expired'


class TooManyAttemptsToActivatePromoCode(MPFSError):
    response = 429
    code = codes.TOO_MANY_ATTEMPTS_TO_ACTIVATE_PROMO_CODE
    message = 'User exceeded her limits for activating promo code'


class UnexpectedPromoCodeState(MPFSError):
    pass


class DiscountTemplateNotFound(MPFSError):
    pass


class AttemptToActivateDiscountRepeatedly(MPFSError):
    response = 409
    code = codes.ATTEMPT_TO_ACTIVATE_DISCOUNT_REPEATEDLY
    message = 'User tried to activate discount that he already had'


class AttemptToActivateArchivedDiscount(AttemptToActivateDiscountRepeatedly):
    pass
