# -*- coding: utf-8 -*-
import datetime

import mpfs.engine.process
from mpfs.core.queue import mpfs_queue
from mpfs.core.social.publicator import Publicator
from mpfs.dao.base import get_all_shard_endpoints
from mpfs.dao.shard_endpoint import ShardEndpoint
from mpfs.core.social.dao.link_data import LinkDataDAO
from mpfs.engine.queue2.celery import BaseTask, app

logger = mpfs.engine.process.get_default_log()


@app.task(base=BaseTask)
def handle_clean_expired_links(raw_shard_endpoint, context=None, **kwargs):
    shard_endpoint = ShardEndpoint.parse(raw_shard_endpoint)
    links = LinkDataDAO().find_expired(shard_endpoint, datetime.datetime.now())
    publicator = Publicator()
    for link in links:
        symlink_hash = '%s:%s' % (link.uid, link.path.strip('/'))
        resource = publicator.fs.get_symlink_resource(link.uid, symlink_hash, True)
        publicator.set_private(link.uid, symlink_hash, resource=resource)


class ExpiredLinksCleanerManager(object):
    @staticmethod
    def run():
        shard_endpoints = get_all_shard_endpoints()
        for shard_endpoint in shard_endpoints:
            mpfs_queue.put(
                {'raw_shard_endpoint': shard_endpoint.serialize()},
                'clean_expired_links',
                deduplication_id=shard_endpoint.get_name()
            )
