# -*- coding: utf-8 -*-
from mpfs.core.metastorage.decorators import without_fsync_safe_w, user_is_writeable
from mpfs.core.pushnotifier.controller import PushController
from mpfs.core.queue import mpfs_queue


@without_fsync_safe_w
@user_is_writeable
def push_subscribe(req):
    """
    Подписка пользователя на push
    """
    return PushController().subscribe(
        req.uid,
        req.callback,
        req.options,
    )


@without_fsync_safe_w
@user_is_writeable
def async_push_subscribe(req):
    data = {
        'uid': req.uid,
        'callback': req.callback,
        'service_callback': req.service_callback,
        'options': req.options,
    }
    mpfs_queue.put(data, 'xiva_subscribe')


def push_unsubscribe(req):
    # Заглушка. Метод не актуален
    return ''


def mobile_subscribe(req):
    events = None
    if req.allow:
        events = list(set(req.allow.split(',')))
    file_ids = None
    if req.resources:
        file_ids = list(set(req.resources.split(',')))

    PushController().mobile_subscribe(
        req.uid,
        req.token,
        events=events,
        file_ids=file_ids,
    )


def mobile_unsubscribe(req):
    PushController().mobile_unsubscribe(req.uid, req.token)
