# -*- coding: utf-8 -*-
"""
DEPRECATED!

После того, как браузерные пуши уедут в SyncServer/Xiva все это можно удалять
"""
import time
import urllib
from itertools import ifilter

import mpfs.engine.process

from mpfs.config import settings
from mpfs.common.util import to_json
from mpfs.core.metastorage import control
from mpfs.engine.http import client as http_client
from mpfs.core.services.push_service import PushSender
from mpfs.core.pushnotifier import actions
from mpfs.common.static.tags.push import *

service_log = mpfs.engine.process.get_service_log('xiva')


class BrowserPushController(object):
    """
    Часть логики скопировано из `mpfs.core.pushnotifier.sync.controller.PushController`, чтобы случайно не сломать пуши в Браузере
    """

    dbcontrol = control.sync_subscription

    def __init__(self):
        self.sender = PushSender()

    def subscriptions(self, uid):
        '''
        Проверка подписки и выдача хостов-урлов
        '''
        return self.dbcontrol.folder_content(uid)

    def subscribe(self, uid, callback, options):
        data = {
            'ctime': int(time.time()),
            'url': callback,
            'options': options,
        }
        return self.dbcontrol.put(uid, data)

    def unsubscribe(self, uid, callback, client_id):
        return self.dbcontrol.unsubscribe(uid, callback, client_id)

    def listener_options(self, listener):
        result = listener.get('ops', {})
        for k, v in settings.push['options'].iteritems():
            if k not in result:
                result[k] = v

        def string_to_array(x):
            unspaced = x.replace(' ', '')
            return unspaced.split(',') if bool(unspaced) else []

        result[ALLOW] = string_to_array(result[ALLOW])
        result[DENY] = string_to_array(result[DENY])
        result[STOPCODE] = int(result[STOPCODE]) if bool(result[STOPCODE]) else 0
        result[RESOURCES] = set(string_to_array(result[RESOURCES]))

        result[STOPCODE] = result[STOPCODE] or 404
        return result

    def send(self, data):

        action = data.get('action_name', 'default')
        pushes = actions.get(action).process(data)

        for item in pushes:
            uid = item.get('uid')
            xdata = item.pop('xiva_data')

            for listener in self.subscriptions(uid):
                options = self.listener_options(listener)
                push_data = dict((t, xdata[t]) for t in ifilter(lambda t: int(t) in options['types'], xdata))
                client_id = options['client_id']
                if client_id != item.get('client_id'):
                    listener_url = listener['url'] + '?u=%s&c=%s' % (uid, urllib.quote(client_id))
                    answer = http_client.open_and_return_code(listener_url,
                                                              log=service_log,
                                                              pure_data=to_json(push_data),
                                                              retry=False,)
                    if options[STOPCODE] and answer == options[STOPCODE]:
                        self.unsubscribe(uid, listener['url'], options['client_id'])
