# -*- coding: utf-8 -*-
"""
Каталог продуктов для Ростелекома

https://st.yandex-team.ru/CHEMODAN-42295
"""
from mpfs.common.static.tags.billing import *
from mpfs.common.static import SPACE_1GB, SPACE_1TB
from mpfs.config import settings

rostelecom_unlim_products = [
    {
        ID: 'rostelecom_unlim_1',
        NAME: {
            RU_RU: u'Безлимит для Ростелекома 1',
            UK_UA: u'Безлимит для Ростелекома 1',
            EN_EN: u'Unlimited for Rostelecom 1',
            TR_TR: u'Unlimited for Rostelecom 1',
        },
        PERIOD: {
            DAY: 30
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: SPACE_1TB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_unlim_2',
        NAME: {
            RU_RU: u'Безлимит для Ростелекома 2',
            UK_UA: u'Безлимит для Ростелекома 2',
            EN_EN: u'Unlimited for Rostelecom 2',
            TR_TR: u'Unlimited for Rostelecom 2',
        },
        PERIOD: {
            DAY: 30
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 * SPACE_1TB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_unlim_3',
        NAME: {
            RU_RU: u'Безлимит для Ростелекома 3',
            UK_UA: u'Безлимит для Ростелекома 3',
            EN_EN: u'Unlimited for Rostelecom 3',
            TR_TR: u'Unlimited for Rostelecom 3',
        },
        PERIOD: {
            DAY: 30
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
        },
        ALTATTRS: True,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_vas_5gb',
        NAME: {
            RU_RU: u'5 ГБ для Ростелекома',
            UK_UA: u'5 ГБ для Ростелекома',
            EN_EN: u'5 GB for Rostelecom',
            TR_TR: u'5 GB for Rostelecom',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 5 * SPACE_1GB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_vas_100gb',
        NAME: {
            RU_RU: u'100 ГБ для Ростелекома',
            UK_UA: u'100 ГБ для Ростелекома',
            EN_EN: u'100 GB for Rostelecom',
            TR_TR: u'100 GB for Rostelecom',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 100 * SPACE_1GB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_vas_1tb',
        NAME: {
            RU_RU: u'1 ТБ для Ростелекома',
            UK_UA: u'1 ТБ для Ростелекома',
            EN_EN: u'1 TB for Rostelecom',
            TR_TR: u'1 TB for Rostelecom',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: SPACE_1TB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
]

rostelecom_unlim_test_products = [
    {
        ID: 'rostelecom_unlim_1_test',
        NAME: {
            RU_RU: u'Безлимит для Ростелекома 1 TEST',
            UK_UA: u'Безлимит для Ростелекома 1 TEST',
            EN_EN: u'Unlimited for Rostelecom 1 TEST',
            TR_TR: u'Unlimited for Rostelecom 1 TEST',
        },
        PERIOD: {
            DAY: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: SPACE_1TB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_unlim_2_test',
        NAME: {
            RU_RU: u'Безлимит для Ростелекома 2 TEST',
            UK_UA: u'Безлимит для Ростелекома 2 TEST',
            EN_EN: u'Unlimited for Rostelecom 2 TEST',
            TR_TR: u'Unlimited for Rostelecom 2 TEST',
        },
        PERIOD: {
            DAY: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 2 * SPACE_1TB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_unlim_3_test',
        NAME: {
            RU_RU: u'Безлимит для Ростелекома 3 TEST',
            UK_UA: u'Безлимит для Ростелекома 3 TEST',
            EN_EN: u'Unlimited for Rostelecom 3 TEST',
            TR_TR: u'Unlimited for Rostelecom 3 TEST',
        },
        PERIOD: {
            DAY: 1
        },
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 3 * SPACE_1TB,
        },
        ALTATTRS: True,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_vas_5gb_test',
        NAME: {
            RU_RU: u'5 ГБ для Ростелекома TEST',
            UK_UA: u'5 ГБ для Ростелекома TEST',
            EN_EN: u'5 GB for Rostelecom TEST',
            TR_TR: u'5 GB for Rostelecom TEST',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 5 * SPACE_1GB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_vas_100gb_test',
        NAME: {
            RU_RU: u'100 ГБ для Ростелекома TEST',
            UK_UA: u'100 ГБ для Ростелекома TEST',
            EN_EN: u'100 GB for Rostelecom TEST',
            TR_TR: u'100 GB for Rostelecom TEST',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: 100 * SPACE_1GB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
    {
        ID: 'rostelecom_vas_1tb_test',
        NAME: {
            RU_RU: u'1 ТБ для Ростелекома TEST',
            UK_UA: u'1 ТБ для Ростелекома TEST',
            EN_EN: u'1 TB for Rostelecom TEST',
            TR_TR: u'1 TB for Rostelecom TEST',
        },
        PERIOD: None,
        AUTO: False,
        PROLONGABLE: False,
        INAPP: False,
        PRICE: {USD: 0, RUB: 0},
        MODULE: 'space',
        CLS: 'BonusSpace',
        SINGLETON: True,
        ATTRIBUTES: {
            AMOUNT: SPACE_1TB,
        },
        ALTATTRS: False,
        PARTNER: 'rostelecom_unlim',
        PARTNER_IPS: settings.billing['partner_ips']['rostelecom_unlim'],
    },
]