# -*- coding: utf-8 -*-
from mpfs.common.errors import MPFSError
from mpfs.common.errors.billing import BillingProductNotFound
from mpfs.common.static import codes

class RostelecomUnlimServiceIsActivated(MPFSError):
    code = codes.ROSTELECOM_UNLIM_SERVICE_IS_ACTIVATED


class RostelecomUnlimServiceIdDeactivated(MPFSError):
    code = codes.ROSTELECOM_UNLIM_SERVICE_IS_DEACTIVATED


class RostelecomUnlimServiceIsBlocked(MPFSError):
    code = codes.ROSTELECOM_UNLIM_SERVICE_IS_BLOCKED


class RostelecomIncorrectNotFound(BillingProductNotFound):
    code = codes.ROSTELECOM_UNLIM_INCORRECT_SERVICE_KEY


class RostelecomUnlimFrozenServiceNotFound(MPFSError):
    pass
