# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис Помощника/Ассистента по профилям

http://wiki.yandex-team.ru/Vertikali/Pomoshnik/backend/api/public

"""
import sys

import mpfs.engine.process
import mpfs.common.errors.platform as errors

from mpfs.common.util import from_json
from mpfs.core.services.common_service import Service
from mpfs.common.static.tags import GET, POST, DELETE
from mpfs.platform.v1.profile import exceptions

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
service_log = mpfs.engine.process.get_service_log('assistant')


class Assistant(Service):

    name = 'assistant'
    api_error = errors.AssistantBadResponse
    log = service_log    

    command_map = {
        'get_football_teams' : {
            'method': GET,
            'location': '/football/'
        },
        'add_football_team': {
            'method': POST,
            'location':'/football/teams/'
        },
        'delete_football_team': {
            'method': DELETE,
            'location': '/football/teams?url=%(url)s'
        },
        'get_movie_genres' : {
            'method': GET,
            'location': '/movie/'
        },
        'add_movie_genre': {
            'method': POST,
            'location':'/movie/genres/'
        },
        'delete_movie_genre': {
            'method': DELETE,
            'location': '/movie/genres?url=%(url)s'
        },
    }
    
    errors_map = {
        404: exceptions.ProfileNotFoundError,
        501: exceptions.ProfileUnknownProfileTypeError,
        422: exceptions.ProfileBadParameterFormatError,
    }

    def process(self, params, body=None, parse_resp=True):
        action = self.command_map[sys._getframe(1).f_code.co_name]
        method, location = action['method'], action['location']
        
        template = self.base_url + location
        url = template % params
        
        for key in params.keys():
            if key in template:
                del(params[key])
    
        headers = {
            'Content-Type': 'application/json; charset=UTF-8',
            self.auth_header_key: self.auth_header_value
        }
        
        try:
            response = self.open_url(
                url, params,
                pure_data=body,
                headers=headers,
                method=method,
                retry=False,
            )
            result = from_json(response) if parse_resp else response
        except self.api_error, e:
            http_code = e.data.get('code')
            code = int(http_code) if http_code else 500
            err_class = self.errors_map.get(code, exceptions.ProfileServiceUnavailableError)
            raise err_class(inner_exception=e)
            
        return result

    def get_football_teams(self, uid):
        '''
        http://wiki.yandex-team.ru/Vertikali/Pomoshnik/backend/api/public#chtenieget
        '''
        response = self.process({'uid': uid})
        try:
            return response['teams']
        except Exception, e:
            raise exceptions.ProfileParserError(inner_exception=e)
    
    def get_movie_genres(self, uid):
        '''
        http://wiki.yandex-team.ru/Vertikali/Pomoshnik/backend/api/public#chtenieget1
        '''
        response = self.process({'uid': uid})
        try:
            return response['genres']
        except Exception, e:
            raise errors.AssistantParserError(e)
        
    def add_football_team(self, uid, teams):
        return self.process({'uid': uid}, body=teams, parse_resp=False)
    
    def delete_football_team(self, uid, team_url):
        return self.process({'uid': uid, 'url': team_url}, parse_resp=False)
    
    def add_movie_genre(self, uid, genres):
        return self.process({'uid': uid}, body=genres, parse_resp=False)
    
    def delete_movie_genre(self, uid, genre_url):
        return self.process({'uid': uid, 'url': genre_url}, parse_resp=False)
      
    
        
assistant = Assistant()
        