# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис аттачей

"""

from mpfs.config import settings
from mpfs.common import errors
from mpfs.core.metastorage.control import attach
from mpfs.core.services.disk_service import StorageSpaceUnlimited, Resources


class Attach(StorageSpaceUnlimited):

    name = 'attach'
    control = attach

    def __init__(self, *args, **kwargs):
        super(Attach, self).__init__(*args, **kwargs)
        from mpfs.core.filesystem.resources.attach import AttachFile, AttachFolder
        self.resources = Resources(dir=AttachFolder, file=AttachFile)

    def free(self, uid):
        return 107374182400

    def used(self, uid):
        size = self.control.sum('data.size', match={'uid': str(uid)})
        return size

    @classmethod
    def is_inside_allowed_folders(cls, address):
        if address.storage_name != 'attach':
            return False

        allowed_folders = settings.folders[address.storage_path].get('allowed_folders', ['/'])
        address_path = cls.add_beginning_and_trailing_slashes(address.path)

        for allowed_folder in allowed_folders:
            allowed_folder = cls.add_beginning_and_trailing_slashes(allowed_folder)
            if address_path.startswith(address.storage_path + allowed_folder):
                return True

        return False

    def make_folder(self, address, *args, **kwargs):
        """Создать папку.

        В случае ошибки отсутствия у пользователя папки /attach, она будет создана автоматически.
        """
        from mpfs.core.user import base as user  # circular import
        uid = address.uid
        try:
            return super(Attach, self).make_folder(address, *args, **kwargs)
        except errors.StorageKeyNotFound as e:
            if isinstance(e.data, dict) and e.data.get('key') == '/attach':
                if user.NeedInit(uid, type='attach'):
                    user.Create(uid, type='attach')
                return super(Attach, self).make_folder(address, *args, **kwargs)
            else:
                raise e
