# -*- coding: utf-8 -*-
"""

MPFS
CORE

Сервис Большого Биллинга

http://wiki.yandex-team.ru/balance/xmlrpc

"""
import copy
import sys

import mpfs.engine.process
import mpfs.common.errors.billing as errors
from mpfs.common.static.tags.billing import *
from mpfs.core.services.common_service import Service

error_log = mpfs.engine.process.get_error_log()
service_log = mpfs.engine.process.get_service_log('bigbilling')


class BalanceXMLRPC(Service):

    name = 'billing'
    log = service_log
    api_error = errors.BigBillingNotResponse

    command_map = {
        'list_payment_methods': 'Balance.ListPaymentMethodsSimple',
        'create_product': 'Balance.CreateServiceProduct',
        'payment_make': 'Balance.PayOrderSimple',
        'unsubscribe': 'Balance.StopSubscriptionSimple',
        'check_order': 'BalanceSimple.CheckOrder',
        'order_place': 'BalanceSimple.CreateOrder',
    }

    errors_map = {

    }

    def process(self, params, valid_status=None):
        if not valid_status:
            valid_status = [SUCCESS, WAIT_FOR_NOTIFICATION]

        method = self.command_map[sys._getframe(1).f_code.co_name]

        try:
            response = self.xmlrpc_call(method, self.token, params)
        except Exception, e:
            error_log.warn(e)
            raise self.api_error(e)

        status = response.get(STATUS) if isinstance(response, dict) else None

        if not status:
            raise errors.BigBillingBadResult(response)
        elif status not in valid_status:
            err_num = response.get(STATUS_DESC)
            err_class = self.errors_map.get(err_num, errors.BigBillingBadResult)
            raise err_class(extra_msg=err_num)
        else:
            return response

    def order_place(self, uid, number, pid, region, locale=None, clid=None, bb_tld=None):
        '''
        Метод работает с API Биллинга 2.0
        https://wiki.yandex-team.ru/Balance/Simple/XMLRPC#balancesimple.createorder
        '''
        params = {
            'uid': uid,
            'service_order_id': number,
            'service_product_id': pid,
            'region_id': region,
        }

        if locale:
            params['locale'] = locale
        if clid:
            params['clid'] = clid
        if bb_tld:
            params['domain_sfx'] = bb_tld
        return self.process(params)

    def list_payment_methods(self, uid, ip):
        '''
        Закрываем пока не сделают дыры до телефонов
        '''
        response = self.process({
            'uid': uid,
            'user_ip': ip
        })
        return response['payment_methods']

    def payment_make(self, uid, number, paymethod_id, ip, callback, return_path):
        result = {'url': None, 'params': None}

        response = self.process({
            'uid': uid,
            'service_order_id': number,
            'paymethod_id': paymethod_id,
            'user_ip': ip,
            'back_url': callback,
            'return_path': return_path,
        })

        try:
            if response['status'] == 'wait_for_notification':
                if 'payment_form' in response:
                    params = copy.copy(response['payment_form'])
                    target = params.pop('_TARGET')
                    result = {'url': target, 'params': params}
            else:
                raise errors.BigBillingBadPaymentResult(response)
        except KeyError:
            raise errors.BigBillingBadPaymentResult(response)

        return result

    def create_product(self, product):
        return self.process(product)

    def unsubscribe(self, uid, ip, number):
        params = {
            'uid': uid,
            'user_ip': ip,
            'service_order_id': number,
            'stop_flag': 1,
        }
        self.process(params, valid_status=[SUCCESS, WAIT_FOR_NOTIFICATION, CANCELLED])

    def check_order(self, uid, ip, number):
        params = {
            'uid': uid,
            'user_ip': ip,
            'service_order_id': number,
        }
        response = self.process(params,  valid_status=[SUCCESS, WAIT_FOR_NOTIFICATION, CANCELLED, REFUND])
        return response
