# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.core.services.balance_xmlrpc import BalanceXMLRPC
from mpfs.core.services.mediabilling_payments import mediabilling_payment_service, MediabillingOrderInfo
from mpfs.core.services.trust_payments import trust_payment_service, BillingOrderInfo

balance_xmlrpc = BalanceXMLRPC()
THIRD_TARIFF_PLUS_PIDS = settings.billing['plus_pids']


def check_is_mediabilling(pid):
    if pid in THIRD_TARIFF_PLUS_PIDS:
        return True
    return False


class BillingServiceRouter(object):
    """
    Маршрутизатор запросов в ББ.

    В зависимости от настроек отправляет запрос в старый BalanceXMLRPC или новый TrustPaymentsService API или в Медиабиллинг
    """

    def order_place(self, uid, number, bb_pid, region, locale=None, clid=None, bb_tld=None,
                    tariff_name=None, ip_address=None, pid=None, template_tag=None, return_path=None):
        if check_is_mediabilling(pid):
            result = mediabilling_payment_service.submit_native_order(uid, ip_address, pid,
                                                                      template_tag=template_tag,
                                                                      return_path=return_path)
            return result

        if trust_payment_service.is_enabled(uid):
            return trust_payment_service.order_place(uid, number, bb_pid, region, tariff_name=tariff_name)
        return balance_xmlrpc.order_place(uid, number, bb_pid, region, locale=locale, clid=clid, bb_tld=bb_tld)

    def list_payment_methods(self, uid, ip, region=None):
        if trust_payment_service.is_enabled(uid):
            return trust_payment_service.list_payment_methods(uid, region)
        return balance_xmlrpc.list_payment_methods(uid, ip)

    def payment_make(self, uid, number, paymethod_id, ip, callback, return_path, bb_tld=None, template_tag=None,
                     locale=None, pid=None):
        if check_is_mediabilling(pid):
            return {}
        if trust_payment_service.is_enabled(uid):
            return trust_payment_service.payment_make(uid, number, paymethod_id, callback, return_path,
                                                      bb_tld=bb_tld, template_tag=template_tag, locale=locale)
        return balance_xmlrpc.payment_make(uid, number, paymethod_id, ip, callback, return_path)

    def create_product(self, product):
        if trust_payment_service.is_enabled():
            return trust_payment_service.create_product(product)
        return balance_xmlrpc.create_product(product)

    def unsubscribe(self, uid, ip, number, pid=None):
        if check_is_mediabilling(pid):
            return mediabilling_payment_service.stop_subscription(uid, pid)
        if trust_payment_service.is_enabled(uid):
            return trust_payment_service.unsubscribe(uid, number)
        balance_xmlrpc.unsubscribe(uid, ip, number)

    def check_order(self, uid, ip, number, convert_to_old_format=True, pid=None):
        if check_is_mediabilling(pid):
            return MediabillingOrderInfo(mediabilling_payment_service.order_info(uid, number))
        if trust_payment_service.is_enabled(uid):
            return BillingOrderInfo(trust_payment_service.check_order(uid, number, convert_to_old_format))
        return BillingOrderInfo(balance_xmlrpc.check_order(uid, ip, number))


BB = BillingServiceRouter()
