# -*- coding: utf-8 -*-
import click


@click.command()
@click.argument("logins", nargs=-1)
def login2uid(logins):
    """
    Преобразовать логины в uid-ы

    Получает список логинов в аргументах, либо с stdin. Выводит uid-ы
    """
    import sys
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()
    from mpfs.core.services.passport_service import passport

    for login in (logins or sys.stdin):
        login = login.strip()
        uid = passport.userinfo(login=login).get('uid')
        if uid:
            click.echo(uid)
        else:
            click.echo("Can't resolve login '%s'" % login, err=True)
            sys.exit(1)
